/// <reference types="react" />
import { UseListItemRootSlotProps } from '../useList';
import { EventHandlers } from '../utils';
export interface SelectOption<Value> {
    value: Value;
    label: React.ReactNode;
    disabled?: boolean;
    ref: React.RefObject<HTMLElement>;
    id?: string;
}
export interface UseOptionParameters<Value> {
    disabled: boolean;
    label: string | React.ReactNode;
    value: Value;
    optionRef?: React.Ref<HTMLElement>;
    id?: string;
}
export interface UseOptionReturnValue {
    selected: boolean;
    highlighted: boolean;
    index: number;
    getRootProps: <Other extends EventHandlers>(otherHandlers?: Other) => UseOptionRootSlotProps<Other>;
    ref: React.RefCallback<HTMLElement>;
}
export type UseOptionRootSlotProps<Other extends EventHandlers = {}> = UseListItemRootSlotProps<Other> & {
    ref?: React.RefCallback<HTMLElement> | null;
} & Other;
