import _extends from "@babel/runtime/helpers/esm/extends";
import * as React from 'react';
import { unstable_useForkRef as useForkRef, unstable_useId as useId } from '@mui/utils';
import { useListItem } from '../useList';
import { useCompoundItem } from '../utils/useCompoundItem';

/**
 *
 * Demos:
 *
 * - [Unstyled Select](https://mui.com/base/react-select/#hooks)
 *
 * API:
 *
 * - [useOption API](https://mui.com/base/react-select/hooks-api/#use-option)
 */
export default function useOption(params) {
  const {
    value,
    label,
    disabled,
    optionRef: optionRefParam,
    id: idParam
  } = params;
  const {
    getRootProps: getListItemProps,
    ref: listItemRefHandler,
    highlighted,
    selected
  } = useListItem({
    item: value
  });
  const id = useId(idParam);
  const optionRef = React.useRef(null);
  const selectOption = React.useMemo(() => ({
    disabled,
    label,
    value,
    ref: optionRef,
    id
  }), [disabled, label, value, id]);
  const {
    index
  } = useCompoundItem(value, selectOption);
  const handleRef = useForkRef(optionRefParam, optionRef, listItemRefHandler);
  return {
    getRootProps: (otherHandlers = {}) => _extends({}, otherHandlers, getListItemProps(otherHandlers), {
      id,
      ref: handleRef,
      role: 'option',
      'aria-selected': selected
    }),
    highlighted,
    index,
    selected,
    ref: handleRef
  };
}