import type { Merge } from 'type-fest';
import type { IGif, IImages, IUser } from '@giphy/js-types';
export type GiphyMediaID = Readonly<{
    id: string;
}>;
export type GiphyMediaData = GiphyMediaID & IGif;
export type GiphyMedia = GiphyMediaID & {
    url: string;
    aspectRatio: number;
    isDynamic: boolean;
    isVideo: boolean;
    data: GiphyMediaData;
};
type GiphyVideo = Exclude<IGif['video'], undefined>;
type NativeAsset = Partial<{
    height: any;
    size: string;
    url: string;
    width: any;
}>;
type NativeAssets = Record<keyof IImages & keyof GiphyVideo['assets'], NativeAsset>;
type NativeTag = string | {
    text: string;
};
type NativeUser = Merge<IUser, Partial<{
    is_public: any;
    is_verified: any;
    suppress_chrome: any;
}>>;
type NativeVideo = Merge<GiphyVideo, {
    assets?: NativeAssets;
}>;
export type NativeGiphyMediaData = Merge<GiphyMediaData, {
    images?: NativeAssets;
    is_anonymous?: any;
    is_community?: any;
    is_dynamic?: any;
    is_featured?: any;
    is_hidden?: any;
    is_indexable?: any;
    is_preserve_size?: any;
    is_realtime?: any;
    is_removed?: any;
    is_sticker?: any;
    tags?: NativeTag[];
    user?: NativeUser;
    video?: NativeVideo;
}>;
export type NativeGiphyMedia = Merge<GiphyMedia, {
    data: NativeGiphyMediaData;
}>;
export declare function deserializeGiphyMedia(rawMedia: NativeGiphyMedia): GiphyMedia;
export {};
//# sourceMappingURL=giphyMedia.d.ts.map