import { noop } from './noop';
let warned = {};
export default function deprecatedPropType() {
  let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  const {
    propType = noop,
    explanation = ''
  } = options;
  return function (props, propName, componentName) {
    if (process.env.NODE_ENV === 'production') {
      return () => null;
    }
    if (props[propName] != null) {
      const message = `"${propName}" property of "${componentName}" has been deprecated. ${explanation}`;
      if (!warned[message]) {
        console.warn(message);
        warned[message] = true;
      }
    }
    for (var _len = arguments.length, rest = new Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
      rest[_key - 3] = arguments[_key];
    }
    return propType(props, propName, componentName, ...rest);
  };
}
//# sourceMappingURL=deprecatedPropType.js.map