const BOOL_PROPS = ['is_anonymous', 'is_community', 'is_featured', 'is_hidden', 'is_indexable', 'is_preserve_size', 'is_realtime', 'is_removed', 'is_sticker', 'is_dynamic'];
const USER_BOOL_PROPS = ['suppress_chrome', 'is_public', 'is_verified'];
const propToBool = obj => prop => {
  obj[prop] = Boolean(obj[prop]);
};
function deserializeTag(tag) {
  return typeof tag === 'string' ? tag : tag.text;
}
function deserializeAssets(assets) {
  const newAssets = {
    ...assets
  };
  Object.entries(newAssets).forEach(_ref => {
    let [key, asset] = _ref;
    newAssets[key] = {
      ...asset,
      width: parseInt(asset?.width, 10) || 0,
      height: parseInt(asset?.height, 10) || 0
    };
  });
  return newAssets;
}
function deserializeUser(user) {
  if (!user) {
    return user;
  }
  const newUser = {
    ...user
  };
  USER_BOOL_PROPS.forEach(propToBool(newUser));
  return newUser;
}
function deserializeVideo(video) {
  if (!video) {
    return video;
  }
  return {
    ...video,
    assets: deserializeAssets(video.assets)
  };
}
function deserializeMediaData(data) {
  const newData = {
    ...data,
    id: String(data?.id),
    images: deserializeAssets(data?.images),
    tags: (data?.tags || []).map(deserializeTag),
    user: deserializeUser(data?.user),
    video: deserializeVideo(data?.video)
  };
  BOOL_PROPS.forEach(propToBool(newData));
  delete newData.images?.mediaId;
  return newData;
}
export function deserializeGiphyMedia(rawMedia) {
  return {
    ...rawMedia,
    data: deserializeMediaData(rawMedia.data)
  };
}
//# sourceMappingURL=giphyMedia.js.map