import { NativeEventEmitter } from 'react-native';
import NativeGiphyDialog from './specs/NativeGiphyDialog';
import { deserializeGiphyMedia } from './dto/giphyMedia';
import { GiphyVideoManager } from './GiphyVideoManager';
import { noop } from './utils/noop';
import { serializeTheme } from './dto/giphyTheme';
export const GiphyDialogEvent = {
  MediaSelected: 'onMediaSelect',
  Dismissed: 'onDismiss'
};
function wrapMediaSelectedListener(listener) {
  return e => {
    e.media = deserializeGiphyMedia(e.media ?? {});
    return listener(e);
  };
}
export const GiphyDialog = new class GiphyDialog extends NativeEventEmitter {
  constructor() {
    super(NativeGiphyDialog);
    // listener stubs
    this.addListener('onMediaSelect', noop);
    this.addListener('onDismiss', noop);
  }
  addListener(eventType, listener) {
    for (var _len = arguments.length, rest = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
      rest[_key - 2] = arguments[_key];
    }
    if (eventType === 'onMediaSelect') {
      return super.addListener(eventType, wrapMediaSelectedListener(listener), ...rest);
    }
    return super.addListener(eventType, listener, ...rest);
  }
  configure(config) {
    NativeGiphyDialog.configure({
      ...config,
      theme: serializeTheme(config.theme ?? 'light')
    });
  }
  show() {
    GiphyVideoManager.pauseAll();
    NativeGiphyDialog.show();
  }
  hide() {
    NativeGiphyDialog.hide();
  }
}();
//# sourceMappingURL=GiphyDialog.js.map