"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GiphyVideoView = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactNative = require("react-native");
var _GiphyVideoManager = require("./GiphyVideoManager");
var _GiphyVideoViewNativeComponent = _interopRequireDefault(require("./specs/GiphyVideoViewNativeComponent"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const BACKGROUND_STATE_REGEX = /inactive|background/;
let mountedComponentsCount = 0;
let appStateListenerAdded = false;
let latestAppState = _reactNative.AppState.currentState;
function appStateListener(appState) {
  if (latestAppState === 'active' && appState.match(BACKGROUND_STATE_REGEX)) {
    _GiphyVideoManager.GiphyVideoManager.pauseAll();
  } else if (appState === 'active' && latestAppState.match(BACKGROUND_STATE_REGEX)) {
    _GiphyVideoManager.GiphyVideoManager.resume();
    _GiphyVideoManager.GiphyVideoManager.muteAll();
  }
  latestAppState = appState;
}
function addAppStateListener() {
  latestAppState = _reactNative.AppState.currentState;
  _reactNative.AppState.addEventListener('change', appStateListener);
  appStateListenerAdded = true;
}
function removeAppStateListener() {
  _reactNative.AppState.addEventListener('change', appStateListener);
  appStateListenerAdded = false;
}
function registerComponent() {
  mountedComponentsCount += 1;
  if (!appStateListenerAdded) {
    addAppStateListener();
  }
}
function unregisterComponent() {
  mountedComponentsCount = Math.max(0, mountedComponentsCount - 1);
  if (mountedComponentsCount === 0 && appStateListenerAdded) {
    removeAppStateListener();
  }
}
class GiphyVideoView extends _react.default.Component {
  componentDidMount() {
    registerComponent();
  }
  componentWillUnmount() {
    unregisterComponent();
  }
  render() {
    const {
      autoPlay = false,
      media,
      muted = false,
      ...other
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_GiphyVideoViewNativeComponent.default, _extends({
      autoPlay: autoPlay,
      mediaId: media?.id,
      muted: muted
    }, other));
  }
}
exports.GiphyVideoView = GiphyVideoView;
//# sourceMappingURL=GiphyVideoView.js.map