import { IGif } from '@giphy/js-types';
import React from 'react';
import { QuartileEvent } from './util';
export type MEDIA_STATE = 'playing' | 'paused';
type IVideo = NonNullable<IGif['video']>;
type Props = {
    onStateChange?: (state: MEDIA_STATE) => void;
    onTimeUpdate?: (playhead: number) => void;
    onError?: (error: number) => void;
    onCanPlay?: () => void;
    onFirstPlay?: (msTillPlay: number) => void;
    onEnded?: () => void;
    onWaiting?: (count: number) => void;
    onLoop?: (count: number) => void;
    onEndFullscreen?: () => void;
    setVideoEl?: (el: HTMLVideoElement) => void;
    onQuartile?: (quartile: QuartileEvent) => void;
    onMuted?: (isMuted: boolean) => void;
    muted?: boolean;
    ccEnabled?: boolean;
    ccLanguage?: keyof NonNullable<IVideo['captions']>;
    loop?: boolean;
    gif: IGif;
    width: number;
    height?: number;
    volume?: number;
    className?: string;
};
declare const Video: {
    ({ muted, ccEnabled, ccLanguage, loop, onStateChange, onTimeUpdate, onCanPlay, onFirstPlay, onWaiting, onMuted, onError, onEnded, onLoop, onQuartile, onEndFullscreen, setVideoEl, gif, width, height: height_, volume, className, }: Props): React.JSX.Element | null;
    className: string;
};
export default Video;
