var __makeTemplateObject = (this && this.__makeTemplateObject) || function (cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import styled from '@emotion/styled';
import React, { useEffect, useState } from 'react';
import Video from './';
import { VolumeOffIcon, VolumeOnIcon } from './controls/volume';
var VideoContainer = styled.div(templateObject_1 || (templateObject_1 = __makeTemplateObject(["\n    position: absolute;\n    top: 0;\n    left: 0;\n    bottom: 0;\n    right: 0;\n    height: 100%;\n    width: 100%;\n"], ["\n    position: absolute;\n    top: 0;\n    left: 0;\n    bottom: 0;\n    right: 0;\n    height: 100%;\n    width: 100%;\n"])));
var VideoStyled = styled(Video)(templateObject_2 || (templateObject_2 = __makeTemplateObject(["\n    height: 100%;\n    display: inline-block;\n    object-fit: fill;\n    pointer-events: none;\n    background: rgb(0, 0, 0, 0);\n"], ["\n    height: 100%;\n    display: inline-block;\n    object-fit: fill;\n    pointer-events: none;\n    background: rgb(0, 0, 0, 0);\n"])));
var Button = styled.div(templateObject_3 || (templateObject_3 = __makeTemplateObject(["\n    position: absolute;\n    top: 6px;\n    right: 6px;\n    cursor: pointer;\n    opacity: ", ";\n    transition: opacity ease-out 800ms;\n"], ["\n    position: absolute;\n    top: 6px;\n    right: 6px;\n    cursor: pointer;\n    opacity: ", ";\n    transition: opacity ease-out 800ms;\n"])), function (props) { return (props.isHovered ? 1 : 0.8); });
var speakerClassName = 'giphy-video-overlay-button';
var VolumeButton = function (_a) {
    var muted = _a.muted, toggleMute = _a.toggleMute, mutedByBrowser = _a.mutedByBrowser, isHovered = _a.isHovered;
    return (React.createElement(Button, { className: speakerClassName, onClick: function (e) {
            e.preventDefault();
            e.stopPropagation();
            toggleMute();
        }, isHovered: isHovered }, muted || mutedByBrowser || !isHovered ? React.createElement(VolumeOffIcon, null) : React.createElement(VolumeOnIcon, null)));
};
var VideoOverlay = function (_a) {
    var gif = _a.gif, isHovered = _a.isHovered, hideMuteButton = _a.hideMuteButton, width = _a.width, height = _a.height, className = _a.className, _b = _a.muted, userPrefMuted = _b === void 0 ? false : _b, onUserMuted = _a.onUserMuted;
    var _c = useState(userPrefMuted), muted = _c[0], setMuted = _c[1];
    var _d = useState(false), mutedByBrowser = _d[0], setMutedByBrowser = _d[1];
    var toggleMute = function () {
        if (mutedByBrowser) {
            setMutedByBrowser(false);
            setMuted(false);
        }
        else {
            onUserMuted === null || onUserMuted === void 0 ? void 0 : onUserMuted(!muted);
            setMuted(!muted);
        }
    };
    useEffect(function () {
        setMuted(userPrefMuted);
    }, [userPrefMuted, setMuted]);
    var props = { toggleMute: toggleMute, muted: muted, mutedByBrowser: mutedByBrowser };
    return (React.createElement(VideoContainer, { className: className },
        isHovered && (React.createElement(VideoStyled, { gif: gif, key: gif.id, loop: true, controls: true, hideAttribution: true, hideMute: true, persistentControls: true, muted: muted, width: width, height: height, onMuted: setMutedByBrowser })),
        !hideMuteButton && React.createElement(VolumeButton, __assign({}, props, { isHovered: isHovered }))));
};
VideoOverlay.imgClassName = speakerClassName;
export default VideoOverlay;
var templateObject_1, templateObject_2, templateObject_3;
//# sourceMappingURL=video-overlay.js.map