import { GifsResult } from '@giphy/js-fetch-api';
import { IGif, IUser } from '@giphy/js-types';
import React, { PureComponent, ElementType } from 'react';
import { debounce } from 'throttle-debounce';
import { EventProps } from './gif';
import type { GifOverlayProps } from './types';
type Props = {
    className?: string;
    user: Partial<IUser>;
    gifHeight: number;
    gifWidth?: number;
    gutter: number;
    fetchGifs: (offset: number) => Promise<GifsResult>;
    onGifsFetched?: (gifs: IGif[]) => void;
    overlay?: ElementType<GifOverlayProps>;
    hideAttribution?: boolean;
    noLink?: boolean;
    noResultsMessage?: string | JSX.Element;
    initialGifs?: IGif[];
    backgroundColor?: string;
    borderRadius?: number;
    tabIndex?: number;
    loaderConfig?: IntersectionObserverInit;
} & EventProps;
type State = {
    isFetching: boolean;
    gifs: IGif[];
    isLoaderVisible: boolean;
    isDoneFetching: boolean;
};
declare class Carousel extends PureComponent<Props, State> {
    static className: string;
    static readonly defaultProps: Readonly<{
        gutter: 6;
        user: {};
        initialGifs: never[];
    }>;
    readonly state: {
        gifs: IGif[];
        isFetching: false;
        isLoaderVisible: false;
        isDoneFetching: false;
    };
    el?: HTMLElement;
    unmounted: boolean;
    paginator: () => Promise<IGif[]>;
    componentDidMount(): void;
    componentWillUnmount(): void;
    onLoaderVisible: (isVisible: boolean) => void;
    onFetch: debounce<() => Promise<void>>;
    render(): React.JSX.Element;
}
export default Carousel;
