"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var js_analytics_1 = require("@giphy/js-analytics");
var js_util_1 = require("@giphy/js-util");
var react_1 = __importStar(require("react"));
var util_1 = require("./util");
var quartileEvents = [0.25, 0.5, 0.75];
var videoClassName = 'giphy-video';
var Network = {
    // The element has not yet been initialized. All attributes are in their initial states.
    EMPTY: 0,
    // The element's resource selection algorithm is active and has selected a resource, but it is not actually using the network at this time.
    IDLE: 1,
    // The user agent is actively trying to download data.
    LOADING: 2,
    // The element's resource selection algorithm is active, but it has not yet found a resource to use.
    NO_SOURCE: 3,
};
var Video = function (_a) {
    var _b, _c, _d;
    var muted = _a.muted, _e = _a.ccEnabled, ccEnabled = _e === void 0 ? false : _e, _f = _a.ccLanguage, ccLanguage = _f === void 0 ? 'en' : _f, _g = _a.loop, loop = _g === void 0 ? true : _g, onStateChange = _a.onStateChange, onTimeUpdate = _a.onTimeUpdate, onCanPlay = _a.onCanPlay, onFirstPlay = _a.onFirstPlay, onWaiting = _a.onWaiting, onMuted = _a.onMuted, onError = _a.onError, onEnded = _a.onEnded, onLoop = _a.onLoop, onQuartile = _a.onQuartile, onEndFullscreen = _a.onEndFullscreen, setVideoEl = _a.setVideoEl, gif = _a.gif, width = _a.width, height_ = _a.height, _h = _a.volume, volume = _h === void 0 ? 0.7 : _h, _j = _a.className, className = _j === void 0 ? videoClassName : _j;
    var height = height_ || (0, js_util_1.getGifHeight)(gif, width);
    // state
    var _k = (0, react_1.useState)((0, js_util_1.getBestVideo)(gif.video, width, height)), media = _k[0], setMedia = _k[1];
    var seek = (0, react_1.useRef)(0);
    if (!media) {
        // Not all gif requests have video content
        // use { type: 'videos' } for search or trending endpoints
        console.warn("GiphyJS No video content for id: ".concat(gif.id));
    }
    var mountTime = (0, react_1.useRef)(Date.now());
    var hasPlayingFired = (0, react_1.useRef)(false);
    var loopNumber = (0, react_1.useRef)(0);
    var waitingCount = (0, react_1.useRef)(0);
    var quartilesFired = (0, react_1.useRef)(new Set());
    // reset the above when the gif.id changes
    (0, react_1.useEffect)(function () {
        mountTime.current = Date.now();
        hasPlayingFired.current = false;
        loopNumber.current = 1;
        waitingCount.current = 0;
        quartilesFired.current = new Set();
    }, [gif.id]);
    var videoEl = (0, react_1.useRef)(null);
    (0, react_1.useEffect)(function () {
        // when the width and height change, check if there's a new url
        var newMedia = (0, js_util_1.getBestVideo)(gif.video, width, height);
        if (videoEl.current && (media === null || media === void 0 ? void 0 : media.url) && newMedia.url !== media.url) {
            // we may have changed gifs, we don't want to seek then
            if (media.url.indexOf(String(gif.id)) !== -1) {
                // when the media changes set the current seek time
                seek.current = videoEl.current.currentTime;
            }
            // triggers re-render with above seek time
            setMedia(newMedia);
        }
    }, [width, height_, gif.video, height, media === null || media === void 0 ? void 0 : media.url, gif.id]);
    (0, react_1.useEffect)(function () {
        if (videoEl.current && (media === null || media === void 0 ? void 0 : media.url) && seek.current) {
            videoEl.current.currentTime = seek.current;
            seek.current = 0;
        }
    }, [media === null || media === void 0 ? void 0 : media.url, seek]);
    var _onError = (0, react_1.useCallback)(function () {
        var _a;
        var el = videoEl.current;
        var code = (_a = el === null || el === void 0 ? void 0 : el.error) === null || _a === void 0 ? void 0 : _a.code;
        if (code && (el === null || el === void 0 ? void 0 : el.src)) {
            var message = (0, util_1.getErrorMessage)(code, el === null || el === void 0 ? void 0 : el.src);
            console.error(message);
            onError === null || onError === void 0 ? void 0 : onError(code);
        }
    }, [onError]);
    var _onPlaying = (0, react_1.useCallback)(function () {
        onStateChange === null || onStateChange === void 0 ? void 0 : onStateChange('playing');
        if (!hasPlayingFired.current) {
            hasPlayingFired.current = true;
            if (gif.analytics_response_payload) {
                (0, js_analytics_1.pingback)({ actionType: 'START', analyticsResponsePayload: gif.analytics_response_payload });
            }
            onFirstPlay === null || onFirstPlay === void 0 ? void 0 : onFirstPlay(Date.now() - mountTime.current);
        }
    }, [onFirstPlay, onStateChange, gif]);
    var _onPaused = (0, react_1.useCallback)(function () { return onStateChange === null || onStateChange === void 0 ? void 0 : onStateChange('paused'); }, [onStateChange]);
    var _onTimeUpdate = (0, react_1.useCallback)(function () {
        var el = videoEl.current;
        if (el) {
            var playhead_1 = el.currentTime;
            quartileEvents.some(function (q) {
                if ((0, util_1.shouldFireQuartile)(q, playhead_1, el.duration, quartilesFired.current, loopNumber.current)) {
                    onQuartile === null || onQuartile === void 0 ? void 0 : onQuartile(q);
                    return true;
                }
                return false;
            });
            onTimeUpdate === null || onTimeUpdate === void 0 ? void 0 : onTimeUpdate(playhead_1 || 0);
        }
    }, [onQuartile, onTimeUpdate]);
    var _onCanPlay = (0, react_1.useCallback)(function () { return onCanPlay === null || onCanPlay === void 0 ? void 0 : onCanPlay(); }, [onCanPlay]);
    var _onWaiting = (0, react_1.useCallback)(function () {
        var el = videoEl.current;
        // we get a waiting event after a loop, so ignore the first one while the play head is 0
        if ((el === null || el === void 0 ? void 0 : el.currentTime) !== 0 && (el === null || el === void 0 ? void 0 : el.networkState) !== Network.IDLE) {
            onWaiting === null || onWaiting === void 0 ? void 0 : onWaiting(++waitingCount.current);
        }
    }, [onWaiting]);
    var _onEnded = (0, react_1.useCallback)(function () {
        // helps prevent two ended events when changing media
        if (!hasPlayingFired.current) {
            return;
        }
        if (loop && videoEl.current) {
            videoEl.current.play();
        }
        onLoop === null || onLoop === void 0 ? void 0 : onLoop(loopNumber.current);
        loopNumber.current = loopNumber.current + 1;
        onEnded === null || onEnded === void 0 ? void 0 : onEnded();
    }, [onEnded, loop, onLoop]);
    var _onEndFullscreen = (0, react_1.useCallback)(function () { return onEndFullscreen === null || onEndFullscreen === void 0 ? void 0 : onEndFullscreen(); }, [onEndFullscreen]);
    var tryAutoPlayWithSound = (0, react_1.useCallback)(function (videoEl) { return __awaiter(void 0, void 0, void 0, function () {
        var promisePlay, error_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!videoEl) return [3 /*break*/, 4];
                    promisePlay = videoEl.play();
                    if (!(promisePlay !== undefined)) return [3 /*break*/, 4];
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 3, , 4]);
                    return [4 /*yield*/, promisePlay];
                case 2:
                    _a.sent();
                    onMuted === null || onMuted === void 0 ? void 0 : onMuted(false);
                    return [3 /*break*/, 4];
                case 3:
                    error_1 = _a.sent();
                    // Autoplay not allowed!
                    // Mute video and try to play again
                    videoEl.muted = true;
                    // Allow the UI to show that the video is muted
                    onMuted === null || onMuted === void 0 ? void 0 : onMuted(true);
                    videoEl.play();
                    return [3 /*break*/, 4];
                case 4: return [2 /*return*/];
            }
        });
    }); }, [onMuted]);
    (0, react_1.useEffect)(function () {
        var el = videoEl.current;
        if (el) {
            tryAutoPlayWithSound(el);
            setVideoEl === null || setVideoEl === void 0 ? void 0 : setVideoEl(el);
            if (!isNaN(volume)) {
                el.volume = volume;
            }
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);
    (0, react_1.useEffect)(function () {
        var el = videoEl.current;
        if (el) {
            el.addEventListener('play', _onPlaying);
            el.addEventListener('pause', _onPaused);
            el.addEventListener('error', _onError);
            el.addEventListener('timeupdate', _onTimeUpdate);
            el.addEventListener('canplay', _onCanPlay);
            el.addEventListener('ended', _onEnded);
            el.addEventListener('waiting', _onWaiting);
            el.addEventListener('webkitendfullscreen', _onEndFullscreen); // this is needed for iOS
        }
        return function () {
            if (el) {
                el.removeEventListener('play', _onPlaying);
                el.removeEventListener('pause', _onPaused);
                el.removeEventListener('error', _onError);
                el.removeEventListener('timeupdate', _onTimeUpdate);
                el.removeEventListener('canplay', _onCanPlay);
                el.removeEventListener('ended', _onEnded);
                el.removeEventListener('waiting', _onWaiting);
                el.removeEventListener('webkitendfullscreen', _onEndFullscreen);
            }
        };
    }, [_onPlaying, _onPaused, _onError, _onTimeUpdate, _onCanPlay, _onEnded, _onWaiting, _onEndFullscreen]);
    var captionSrc = (_d = (_c = (_b = gif.video) === null || _b === void 0 ? void 0 : _b.captions) === null || _c === void 0 ? void 0 : _c[ccLanguage]) === null || _d === void 0 ? void 0 : _d.vtt;
    return (media === null || media === void 0 ? void 0 : media.url) ? (react_1.default.createElement("video", { crossOrigin: "anonymous", draggable: true, className: className, width: width, height: height, muted: muted, autoPlay: true, playsInline: true, ref: videoEl, src: media === null || media === void 0 ? void 0 : media.url, "data-giphy-id": gif.id }, ccEnabled && captionSrc && (react_1.default.createElement("track", { label: "English", kind: "subtitles", srcLang: ccLanguage, src: captionSrc, default: true })))) : null;
};
Video.className = videoClassName;
exports.default = Video;
//# sourceMappingURL=video.js.map