"use strict";
var __makeTemplateObject = (this && this.__makeTemplateObject) || function (cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var styled_1 = __importDefault(require("@emotion/styled"));
var js_fetch_api_1 = require("@giphy/js-fetch-api");
var js_util_1 = require("@giphy/js-util");
var react_1 = __importStar(require("react"));
var throttle_debounce_1 = require("throttle-debounce");
var observer_1 = __importDefault(require("../util/observer"));
var fetch_error_1 = __importDefault(require("./fetch-error"));
var gif_1 = __importDefault(require("./gif"));
var loader_1 = __importDefault(require("./loader"));
var masonry_grid_1 = __importDefault(require("./masonry-grid"));
var pingback_context_manager_1 = __importDefault(require("./pingback-context-manager"));
var Loader = styled_1.default.div(templateObject_1 || (templateObject_1 = __makeTemplateObject(["\n    opacity: ", ";\n"], ["\n    opacity: ", ";\n"])), function (props) { return (props.isFirstLoad ? 0 : 1); });
var defaultProps = Object.freeze({ gutter: 6, user: {}, initialGifs: [] });
var initialState = Object.freeze({
    isFetching: false,
    isError: false,
    gifWidth: 0,
    gifs: [],
    isLoaderVisible: false,
    isDoneFetching: false,
});
var Grid = /** @class */ (function (_super) {
    __extends(Grid, _super);
    function Grid() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = __assign(__assign({}, initialState), { gifs: _this.props.initialGifs || [] });
        _this.unmounted = false;
        _this.paginator = (0, js_fetch_api_1.gifPaginator)(_this.props.fetchGifs, _this.state.gifs);
        _this.onLoaderVisible = function (isVisible) {
            if (_this.unmounted)
                return;
            _this.setState({ isLoaderVisible: isVisible }, _this.onFetch);
        };
        _this.fetchGifs = (0, throttle_debounce_1.debounce)(Grid.fetchDebounce, function (prefetchCount) { return __awaiter(_this, void 0, void 0, function () {
            var gifs, error_1, onGifsFetchError, onGifsFetched;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, this.paginator()];
                    case 1:
                        gifs = _a.sent();
                        if (this.unmounted)
                            return [2 /*return*/];
                        return [3 /*break*/, 3];
                    case 2:
                        error_1 = _a.sent();
                        if (this.unmounted)
                            return [2 /*return*/];
                        this.setState({ isFetching: false, isError: true });
                        onGifsFetchError = this.props.onGifsFetchError;
                        if (onGifsFetchError)
                            onGifsFetchError(error_1);
                        return [3 /*break*/, 3];
                    case 3:
                        if (gifs) {
                            // if we've just fetched and we don't have
                            // any more gifs, we're done fetching
                            if (prefetchCount === gifs.length) {
                                this.setState({ isDoneFetching: true });
                            }
                            else {
                                this.setState({ gifs: gifs, isFetching: false });
                                onGifsFetched = this.props.onGifsFetched;
                                if (onGifsFetched)
                                    onGifsFetched(gifs);
                                this.onFetch();
                            }
                        }
                        return [2 /*return*/];
                }
            });
        }); });
        _this.onFetch = function () { return __awaiter(_this, void 0, void 0, function () {
            var _a, isFetching, isLoaderVisible, gifs;
            return __generator(this, function (_b) {
                if (this.unmounted)
                    return [2 /*return*/];
                _a = this.state, isFetching = _a.isFetching, isLoaderVisible = _a.isLoaderVisible, gifs = _a.gifs;
                if (!isFetching && isLoaderVisible) {
                    this.setState({ isFetching: true, isError: false });
                    this.fetchGifs(gifs.length);
                }
                return [2 /*return*/];
            });
        }); };
        return _this;
    }
    Grid.prototype.componentDidMount = function () {
        this.unmounted = false;
        this.onFetch();
    };
    Grid.prototype.componentWillUnmount = function () {
        this.unmounted = true;
    };
    Grid.prototype.render = function () {
        var _a = this.props, onGifVisible = _a.onGifVisible, onGifRightClick = _a.onGifRightClick, _b = _a.className, className = _b === void 0 ? Grid.className : _b, onGifSeen = _a.onGifSeen, onGifClick = _a.onGifClick, onGifKeyPress = _a.onGifKeyPress, user = _a.user, overlay = _a.overlay, hideAttribution = _a.hideAttribution, noLink = _a.noLink, borderRadius = _a.borderRadius, noResultsMessage = _a.noResultsMessage, columns = _a.columns, width = _a.width, gutter = _a.gutter, useTransform = _a.useTransform, columnOffsets = _a.columnOffsets, backgroundColor = _a.backgroundColor, loaderConfig = _a.loaderConfig, _c = _a.tabIndex, tabIndex = _c === void 0 ? 0 : _c, _d = _a.layoutType, layoutType = _d === void 0 ? 'GRID' : _d, _e = _a.loader, LoaderVisual = _e === void 0 ? loader_1.default : _e;
        var _f = this.state, gifWidth = _f.gifWidth, gifs = _f.gifs, isError = _f.isError, isDoneFetching = _f.isDoneFetching;
        var showLoader = !isDoneFetching;
        var isFirstLoad = gifs.length === 0;
        // get the height of each grid item
        var itemHeights = gifs.map(function (gif) { return (0, js_util_1.getGifHeight)(gif, gifWidth); });
        return (react_1.default.createElement(pingback_context_manager_1.default, { attributes: { layout_type: layoutType } },
            react_1.default.createElement("div", { className: className, style: { width: width } },
                react_1.default.createElement(masonry_grid_1.default, { itemHeights: itemHeights, useTransform: useTransform, itemWidth: gifWidth, columns: columns, gutter: gutter, columnOffsets: columnOffsets }, gifs.map(function (gif) { return (react_1.default.createElement(gif_1.default, { gif: gif, tabIndex: tabIndex, key: gif.id, width: gifWidth, onGifClick: onGifClick, onGifKeyPress: onGifKeyPress, onGifSeen: onGifSeen, onGifVisible: onGifVisible, onGifRightClick: onGifRightClick, user: user, overlay: overlay, backgroundColor: backgroundColor, hideAttribution: hideAttribution, noLink: noLink, borderRadius: borderRadius })); })),
                !showLoader && gifs.length === 0 && noResultsMessage,
                isError ? (react_1.default.createElement(fetch_error_1.default, { onClick: this.onFetch })) : (showLoader && (react_1.default.createElement(observer_1.default, { onVisibleChange: this.onLoaderVisible, config: loaderConfig },
                    react_1.default.createElement(Loader, { isFirstLoad: isFirstLoad },
                        react_1.default.createElement(LoaderVisual, { className: Grid.loaderClassName }))))))));
    };
    Grid.className = 'giphy-grid';
    Grid.loaderClassName = 'loader';
    Grid.fetchDebounce = 250;
    Grid.defaultProps = defaultProps;
    Grid.getDerivedStateFromProps = function (_a, prevState) {
        var columns = _a.columns, gutter = _a.gutter, width = _a.width;
        var gutterOffset = gutter * (columns - 1);
        var gifWidth = Math.floor((width - gutterOffset) / columns);
        if (prevState.gifWidth !== gifWidth) {
            return { gifWidth: gifWidth };
        }
        return null;
    };
    return Grid;
}(react_1.PureComponent));
exports.default = Grid;
var templateObject_1;
//# sourceMappingURL=grid.js.map