var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
/* eslint-disable no-dupe-class-members */
import { getPingbackId } from '@giphy/js-util';
import qs from 'qs';
import { normalizeGif, normalizeGifs } from './normalize/gif';
import request from './request';
var getType = function (options) { return (options && options.type ? options.type : 'gifs'); };
/**
 * @class GiphyFetch
 * @param {string} apiKey
 */
var GiphyFetch = /** @class */ (function () {
    function GiphyFetch(apiKey) {
        var _this = this;
        /**
         * @hidden
         */
        this.getQS = function (options) {
            if (options === void 0) { options = {}; }
            return qs.stringify(__assign(__assign({}, options), { api_key: _this.apiKey, pingback_id: getPingbackId() }));
        };
        this.apiKey = apiKey;
    }
    /**
     * A list of categories
     *
     * @param {CategoriesOptions} [options]
     * @returns {Promise<CategoriesResult>}
     */
    GiphyFetch.prototype.categories = function (options) {
        return request("gifs/categories?".concat(this.getQS(options)));
    };
    /**
     * Get a single gif by a id
     * @param {string} id
     * @returns {Promise<GifsResult>}
     **/
    GiphyFetch.prototype.gif = function (id) {
        return request("gifs/".concat(id, "?").concat(this.getQS()), { normalizer: normalizeGif });
    };
    GiphyFetch.prototype.gifs = function (arg1, arg2) {
        if (Array.isArray(arg1)) {
            return request("gifs?".concat(this.getQS({ ids: arg1.join(',') })), {
                normalizer: normalizeGifs,
            });
        }
        return request("gifs/categories/".concat(arg1, "/").concat(arg2, "?").concat(this.getQS()), {
            normalizer: normalizeGifs,
        });
    };
    GiphyFetch.prototype.emoji = function (options) {
        return request("emoji?".concat(this.getQS(options)), { normalizer: normalizeGifs });
    };
    /**
     * Returns a list of all the default emoji variations
     *
     * @param {PaginationOptions} options
     * @returns {Promise<GifsResult>}
     **/
    GiphyFetch.prototype.emojiDefaultVariations = function (options) {
        return request("emoji?".concat(this.getQS(options)), {
            apiVersion: 2,
            normalizer: normalizeGifs,
        });
    };
    /**
     * Returns a list of gifs representing all the variations for the emoji
     *
     * @param {string} id
     * @returns {Promise<NonPaginatedGifsResult>}
     **/
    GiphyFetch.prototype.emojiVariations = function (id) {
        return request("emoji/".concat(id, "/variations?").concat(this.getQS()), {
            apiVersion: 2,
            normalizer: normalizeGifs,
        });
    };
    GiphyFetch.prototype.animate = function (text, options) {
        if (options === void 0) { options = {}; }
        var qsParams = this.getQS(__assign(__assign({}, options), { m: text }));
        return request("text/animate?".concat(qsParams), { normalizer: normalizeGifs });
    };
    /**
     * @param term: string The term you're searching for
     * @param options: SearchOptions
     * @returns {Promise<GifsResult>}
     **/
    GiphyFetch.prototype.search = function (term, options) {
        if (options === void 0) { options = {}; }
        var q = options.channel ? "@".concat(options.channel, " ").concat(term) : term;
        var excludeDynamicResults;
        if (options.type === 'text') {
            excludeDynamicResults = true;
        }
        var qsParams = this.getQS(__assign(__assign({ rating: 'pg-13' }, options), { q: q, excludeDynamicResults: excludeDynamicResults }));
        return request("".concat(getType(options), "/search?").concat(qsParams), { normalizer: normalizeGifs });
    };
    /**
     * Get a list of subcategories
     * @param {string} category
     * @param {SubcategoriesOptions} options
     * @returns {Promise<CategoriesResult>}
     */
    GiphyFetch.prototype.subcategories = function (category, options) {
        return request("gifs/categories/".concat(category, "?").concat(this.getQS(options)));
    };
    /**
     * Get trending gifs
     *
     * @param {TrendingOptions} options
     * @returns {Promise<GifsResult>}
     */
    GiphyFetch.prototype.trending = function (options) {
        if (options === void 0) { options = {}; }
        return request("".concat(getType(options), "/trending?").concat(this.getQS(__assign({ rating: 'pg-13' }, options))), {
            normalizer: normalizeGifs,
        });
    };
    /**
     * Get a random gif
     * @param {RandomOptions} options
     * @returns {Promise<GifResult>}
     **/
    GiphyFetch.prototype.random = function (options) {
        return request("".concat(getType(options), "/random?").concat(this.getQS(__assign({ rating: 'pg-13' }, options))), {
            noCache: true,
            normalizer: normalizeGif,
        });
    };
    /**
     * Get related gifs by a id
     * @param {string} id
     * @param {SubcategoriesOptions} options
     * @returns {Promise<GifsResult>}
     **/
    GiphyFetch.prototype.related = function (id, options) {
        return request("".concat((options === null || options === void 0 ? void 0 : options.type) === 'stickers' ? 'stickers' : 'gifs', "/related?").concat(this.getQS(__assign({ gif_id: id, rating: 'pg-13' }, options))), { normalizer: normalizeGifs });
    };
    /**
     * Search for channels based on a term
     * @param {string} term
     * @param options: SearchOptions
     * @returns {Promise<ChannelsResult>}
     **/
    GiphyFetch.prototype.channels = function (term, options) {
        if (options === void 0) { options = {}; }
        return request("channels/search?".concat(this.getQS(__assign({ q: term, rating: 'pg-13' }, options))));
    };
    return GiphyFetch;
}());
export { GiphyFetch };
export default GiphyFetch;
//# sourceMappingURL=api.js.map