"use strict";
var __makeTemplateObject = (this && this.__makeTemplateObject) || function (cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.css = exports.fontSize = exports.fontFamily = exports.addFonts = void 0;
var emotion_1 = require("emotion");
var addFonts = function () { };
exports.addFonts = addFonts;
try {
    // in an env where process.env exists,
    // this will not error allowing the configuration
    // to work
    if (!process.env.GIPHY_SDK_NO_FONTS) {
        (0, exports.addFonts)();
    }
}
catch (error) {
    // if there is no env then fallback to the default behavior
    (0, exports.addFonts)();
}
exports.fontFamily = {
    title: "'nexablack', sans-serif",
    body: 'interface, Helvetica Neue, helvetica, sans-serif;',
};
exports.fontSize = {
    titleSmall: '20px',
    title: '26px',
    titleLarge: '36px',
    subheader: '16px',
    subheaderSmall: '12px',
};
var sharedTitle = (0, emotion_1.css)(templateObject_2 || (templateObject_2 = __makeTemplateObject(["\n    font-family: ", ";\n    -webkit-font-smoothing: antialiased;\n"], ["\n    font-family: ", ";\n    -webkit-font-smoothing: antialiased;\n"])), exports.fontFamily.title);
var title = (0, emotion_1.cx)((0, emotion_1.css)(templateObject_3 || (templateObject_3 = __makeTemplateObject(["\n        font-size: ", ";\n    "], ["\n        font-size: ", ";\n    "])), exports.fontSize.title), sharedTitle);
var titleLarge = (0, emotion_1.cx)((0, emotion_1.css)(templateObject_4 || (templateObject_4 = __makeTemplateObject(["\n        font-size: ", ";\n    "], ["\n        font-size: ", ";\n    "])), exports.fontSize.titleLarge), sharedTitle);
var titleSmall = (0, emotion_1.cx)((0, emotion_1.css)(templateObject_5 || (templateObject_5 = __makeTemplateObject(["\n        font-size: ", ";\n    "], ["\n        font-size: ", ";\n    "])), exports.fontSize.titleSmall), sharedTitle);
var sharedSubheader = (0, emotion_1.css)(templateObject_6 || (templateObject_6 = __makeTemplateObject(["\n    font-family: ", ";\n    font-weight: bold;\n    -webkit-font-smoothing: antialiased;\n"], ["\n    font-family: ", ";\n    font-weight: bold;\n    -webkit-font-smoothing: antialiased;\n"])), exports.fontFamily.body);
var subheader = (0, emotion_1.cx)((0, emotion_1.css)(templateObject_7 || (templateObject_7 = __makeTemplateObject(["\n        font-size: ", ";\n    "], ["\n        font-size: ", ";\n    "])), exports.fontSize.subheader), sharedSubheader);
var subheaderSmall = (0, emotion_1.cx)((0, emotion_1.css)(templateObject_8 || (templateObject_8 = __makeTemplateObject(["\n        font-size: ", ";\n    "], ["\n        font-size: ", ";\n    "])), exports.fontSize.subheaderSmall), sharedSubheader);
var sectionHeader = (0, emotion_1.css)(templateObject_9 || (templateObject_9 = __makeTemplateObject(["\n    font-family: ", ";\n    font-size: 14px;\n    font-weight: bold;\n    text-transform: uppercase;\n    -webkit-font-smoothing: antialiased;\n"], ["\n    font-family: ", ";\n    font-size: 14px;\n    font-weight: bold;\n    text-transform: uppercase;\n    -webkit-font-smoothing: antialiased;\n"])), exports.fontFamily.body);
var classNames = {
    sectionHeader: sectionHeader,
    subheaderSmall: subheaderSmall,
    subheader: subheader,
    titleLarge: titleLarge,
    titleSmall: titleSmall,
    title: title,
};
exports.css = classNames;
var templateObject_1, templateObject_2, templateObject_3, templateObject_4, templateObject_5, templateObject_6, templateObject_7, templateObject_8, templateObject_9;
//# sourceMappingURL=typography.js.map