var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var _a;
import { getPingbackId, Logger } from '@giphy/js-util';
import { debounce } from 'throttle-debounce';
import gl from './global';
import { sendPingback } from './send-pingback';
var queuedPingbackEvents = [];
gl.giphyRandomId = getPingbackId();
var loggedInUserId = '';
function sendPingbacks() {
    var sendEvents = __spreadArray([], queuedPingbackEvents, true);
    queuedPingbackEvents = [];
    sendPingback(sendEvents);
}
var debouncedPingbackEvent = debounce(1000, sendPingbacks);
(_a = gl.addEventListener) === null || _a === void 0 ? void 0 : _a.call(gl, 'beforeunload', sendPingbacks);
var pingback = function (_a) {
    var userId = _a.userId, eventType = _a.eventType, actionType = _a.actionType, attributes = _a.attributes, _b = _a.queueEvents, queueEvents = _b === void 0 ? true : _b, analyticsResponsePayload = _a.analyticsResponsePayload;
    // save the user id for whenever create session is invoked
    loggedInUserId = userId ? String(userId) : loggedInUserId;
    var newEvent = {
        ts: Date.now(),
        attributes: attributes,
        action_type: actionType,
        user_id: getPingbackId(),
        analytics_response_payload: analyticsResponsePayload,
    };
    if (loggedInUserId) {
        newEvent.logged_in_user_id = loggedInUserId;
    }
    // add verification mode
    if (newEvent.analytics_response_payload) {
        newEvent.analytics_response_payload = "".concat(newEvent.analytics_response_payload).concat(Logger.ENABLED ? '&mode=verification' : '');
    }
    if (eventType) {
        newEvent.event_type = eventType;
    }
    queuedPingbackEvents.push(newEvent);
    queueEvents ? debouncedPingbackEvent() : sendPingbacks();
};
export default pingback;
//# sourceMappingURL=pingback.js.map