import { BaseEvent, SpecialEventType } from './baseEvent';
export declare enum IdentifyOperation {
    SET = "$set",
    SET_ONCE = "$setOnce",
    ADD = "$add",
    APPEND = "$append",
    PREPEND = "$prepend",
    REMOVE = "$remove",
    PREINSERT = "$preInsert",
    POSTINSERT = "$postInsert",
    UNSET = "$unset",
    CLEAR_ALL = "$clearAll"
}
export declare type ValidPropertyType = number | string | boolean | Array<string | number> | {
    [key: string]: ValidPropertyType;
};
interface BaseOperationConfig {
    [key: string]: ValidPropertyType;
}
export interface IdentifyUserProperties {
    [IdentifyOperation.ADD]?: {
        [key: string]: number;
    };
    [IdentifyOperation.UNSET]?: BaseOperationConfig;
    [IdentifyOperation.CLEAR_ALL]?: any;
    [IdentifyOperation.SET]?: BaseOperationConfig;
    [IdentifyOperation.SET_ONCE]?: BaseOperationConfig;
    [IdentifyOperation.APPEND]?: BaseOperationConfig;
    [IdentifyOperation.PREPEND]?: BaseOperationConfig;
    [IdentifyOperation.POSTINSERT]?: BaseOperationConfig;
    [IdentifyOperation.PREINSERT]?: BaseOperationConfig;
    [IdentifyOperation.REMOVE]?: BaseOperationConfig;
}
export interface IdentifyEvent extends BaseEvent {
    event_type: SpecialEventType.IDENTIFY;
    user_properties: IdentifyUserProperties | {
        [key in Exclude<string, IdentifyOperation>]: any;
    };
}
export interface GroupIdentifyEvent extends BaseEvent {
    event_type: SpecialEventType.GROUP_IDENTIFY;
    group_properties: IdentifyUserProperties | {
        [key in Exclude<string, IdentifyOperation>]: any;
    };
}
export {};
//# sourceMappingURL=identify.d.ts.map