import { AnalyticsIdentity, Plugin } from './types/plugin';
import { CoreClient } from './core-client';
import { IConfig } from './config';
import { EventCallback } from './types/event-callback';
import { Event } from './types/event/event';
import { Result } from './types/result';
export declare class Timeline {
    private client;
    queue: [Event, EventCallback][];
    applying: boolean;
    plugins: Plugin[];
    constructor(client: CoreClient);
    register(plugin: Plugin, config: IConfig): Promise<void>;
    deregister(pluginName: string, config: IConfig): Promise<void>;
    reset(client: CoreClient): void;
    push(event: Event): Promise<Result>;
    scheduleApply(timeout: number): void;
    apply(item: [Event, EventCallback] | undefined): Promise<void>;
    flush(): Promise<void>;
    onIdentityChanged(identity: AnalyticsIdentity): void;
    onSessionIdChanged(sessionId: number): void;
    onOptOutChanged(optOut: boolean): void;
}
//# sourceMappingURL=timeline.d.ts.map