"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SpecialEventType = exports.IdentifyOperation = void 0;
var IdentifyOperation;
(function (IdentifyOperation) {
    // Base Operations to set values
    IdentifyOperation["SET"] = "$set";
    IdentifyOperation["SET_ONCE"] = "$setOnce";
    // Operations around modifying existing values
    IdentifyOperation["ADD"] = "$add";
    IdentifyOperation["APPEND"] = "$append";
    IdentifyOperation["PREPEND"] = "$prepend";
    IdentifyOperation["REMOVE"] = "$remove";
    // Operations around appending values *if* they aren't present
    IdentifyOperation["PREINSERT"] = "$preInsert";
    IdentifyOperation["POSTINSERT"] = "$postInsert";
    // Operations around removing properties/values
    IdentifyOperation["UNSET"] = "$unset";
    IdentifyOperation["CLEAR_ALL"] = "$clearAll";
})(IdentifyOperation = exports.IdentifyOperation || (exports.IdentifyOperation = {}));
/**
 * Strings that have special meaning when used as an event's type
 * and have different specifications.
 */
var SpecialEventType;
(function (SpecialEventType) {
    SpecialEventType["IDENTIFY"] = "$identify";
    SpecialEventType["GROUP_IDENTIFY"] = "$groupidentify";
    SpecialEventType["REVENUE"] = "revenue_amount";
})(SpecialEventType = exports.SpecialEventType || (exports.SpecialEventType = {}));
//# sourceMappingURL=event.js.map