"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebAttribution = void 0;
var tslib_1 = require("tslib");
var analytics_core_1 = require("@amplitude/analytics-core");
var helpers_1 = require("./helpers");
var campaign_parser_1 = require("./campaign-parser");
var constants_1 = require("./constants");
var WebAttribution = /** @class */ (function () {
    function WebAttribution(options, config) {
        var _a;
        this.shouldTrackNewCampaign = false;
        this.options = tslib_1.__assign({ initialEmptyValue: 'EMPTY', resetSessionOnNewCampaign: false, excludeReferrers: (0, helpers_1.getDefaultExcludedReferrers)((_a = config.cookieOptions) === null || _a === void 0 ? void 0 : _a.domain) }, options);
        this.storage = config.cookieStorage;
        this.storageKey = (0, analytics_core_1.getStorageKey)(config.apiKey, 'MKTG');
        this.currentCampaign = constants_1.BASE_CAMPAIGN;
        this.sessionTimeout = config.sessionTimeout;
        this.lastEventTime = config.lastEventTime;
        this.logger = config.loggerProvider;
        config.loggerProvider.log('Installing web attribution tracking.');
    }
    WebAttribution.prototype.init = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var isEventInNewSession;
            var _a;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, this.fetchCampaign()];
                    case 1:
                        _a = tslib_1.__read.apply(void 0, [_b.sent(), 2]), this.currentCampaign = _a[0], this.previousCampaign = _a[1];
                        isEventInNewSession = !this.lastEventTime ? true : (0, analytics_core_1.isNewSession)(this.sessionTimeout, this.lastEventTime);
                        if (!(0, helpers_1.isNewCampaign)(this.currentCampaign, this.previousCampaign, this.options, this.logger, isEventInNewSession)) return [3 /*break*/, 3];
                        this.shouldTrackNewCampaign = true;
                        return [4 /*yield*/, this.storage.set(this.storageKey, this.currentCampaign)];
                    case 2:
                        _b.sent();
                        _b.label = 3;
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    WebAttribution.prototype.fetchCampaign = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, Promise.all([new campaign_parser_1.CampaignParser().parse(), this.storage.get(this.storageKey)])];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    /**
     * This can be called when enable web attribution and either
     * 1. set a new session
     * 2. has new campaign and enable resetSessionOnNewCampaign
     */
    WebAttribution.prototype.generateCampaignEvent = function (event_id) {
        // Mark this campaign has been tracked
        this.shouldTrackNewCampaign = false;
        var campaignEvent = (0, helpers_1.createCampaignEvent)(this.currentCampaign, this.options);
        if (event_id) {
            campaignEvent.event_id = event_id;
        }
        return campaignEvent;
    };
    WebAttribution.prototype.shouldSetSessionIdOnNewCampaign = function () {
        return this.shouldTrackNewCampaign && !!this.options.resetSessionOnNewCampaign;
    };
    return WebAttribution;
}());
exports.WebAttribution = WebAttribution;
//# sourceMappingURL=web-attribution.js.map