"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PerformanceResourceTiming = exports.PerformanceReactNativeMark = exports.PerformanceMetric = exports.PerformanceMeasure = exports.PerformanceMark = exports.PerformanceEntry = void 0;
class PerformanceEntry {
  constructor(name, entryType, startTime, duration) {
    this.name = name;
    this.entryType = entryType;
    this.startTime = startTime;
    this.duration = duration;
  }
  toJSON() {
    return {
      name: this.name,
      entryType: this.entryType,
      startTime: this.startTime,
      duration: this.duration
    };
  }
}
exports.PerformanceEntry = PerformanceEntry;
class PerformanceMark extends PerformanceEntry {
  constructor(markName) {
    let markOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    super(markName, 'mark', markOptions.startTime, 0);
    this.detail = markOptions.detail;
  }
  toJSON() {
    return {
      name: this.name,
      entryType: this.entryType,
      startTime: this.startTime,
      duration: this.duration,
      detail: this.detail
    };
  }
}
exports.PerformanceMark = PerformanceMark;
class PerformanceReactNativeMark extends PerformanceEntry {
  constructor(name, startTime, detail) {
    super(name, 'react-native-mark', startTime, 0);
    this.detail = detail;
  }
  toJSON() {
    return {
      name: this.name,
      entryType: this.entryType,
      startTime: this.startTime,
      duration: this.duration,
      detail: this.detail
    };
  }
}
exports.PerformanceReactNativeMark = PerformanceReactNativeMark;
class PerformanceMetric extends PerformanceEntry {
  constructor(name, metricOptions) {
    super(name, 'metric', metricOptions.startTime, 0);
    this.value = metricOptions.value;
    this.detail = metricOptions.detail;
  }
  toJSON() {
    return {
      name: this.name,
      entryType: this.entryType,
      startTime: this.startTime,
      duration: this.duration,
      detail: this.detail,
      value: this.value
    };
  }
}
exports.PerformanceMetric = PerformanceMetric;
class PerformanceMeasure extends PerformanceEntry {
  constructor(measureName) {
    let measureOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    super(measureName, 'measure', measureOptions.startTime, measureOptions.duration);
    this.detail = measureOptions.detail;
  }
  toJSON() {
    return {
      name: this.name,
      entryType: this.entryType,
      startTime: this.startTime,
      duration: this.duration,
      detail: this.detail
    };
  }
}
exports.PerformanceMeasure = PerformanceMeasure;
class PerformanceResourceTiming extends PerformanceEntry {
  constructor() {
    let {
      name,
      startTime,
      duration,
      initiatorType,
      responseEnd,
      transferSize
    } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    super(name, 'resource', startTime, duration);
    this.initiatorType = initiatorType;
    this.fetchStart = startTime;
    this.responseEnd = responseEnd;
    this.transferSize = transferSize;
    this.connectEnd = 0;
    this.connectStart = 0;
    this.decodedBodySize = 0;
    this.domainLookupEnd = 0;
    this.domainLookupStart = 0;
    this.encodedBodySize = 0;
    this.redirectEnd = 0;
    this.redirectStart = 0;
    this.requestStart = 0;
    this.responseStart = 0;
    this.secureConnectionStart = 0;
    this.serverTiming = [];
    this.transferSize = 0;
    this.workerStart = 0;
    this.workerTiming = [];
  }
  toJSON() {
    return {
      name: this.name,
      entryType: this.entryType,
      startTime: this.startTime,
      duration: this.duration,
      initiatorType: this.initiatorType,
      fetchStart: this.fetchStart,
      responseEnd: this.responseEnd,
      transferSize: this.transferSize,
      connectEnd: this.connectEnd,
      connectStart: this.connectStart,
      decodedBodySize: this.decodedBodySize,
      domainLookupEnd: this.domainLookupEnd,
      domainLookupStart: this.domainLookupStart,
      encodedBodySize: this.encodedBodySize,
      redirectEnd: this.redirectEnd,
      redirectStart: this.redirectStart,
      requestStart: this.requestStart,
      responseStart: this.responseStart,
      secureConnectionStart: this.secureConnectionStart,
      serverTiming: this.serverTiming,
      workerStart: this.workerStart,
      workerTiming: this.workerTiming
    };
  }
}
exports.PerformanceResourceTiming = PerformanceResourceTiming;
//# sourceMappingURL=performance-entry.js.map