"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setResourceLoggingEnabled = exports.default = exports.PerformanceObserver = void 0;
var _reactNative = require("react-native");
var _performance = require("./performance");
var _performanceEntry = require("./performance-entry");
var _resourceLogger = require("./resource-logger");
const {
  PerformanceObserver,
  addEntry,
  performance
} = (0, _performance.createPerformance)();
exports.PerformanceObserver = PerformanceObserver;
const isTurboModuleEnabled = global.__turboModuleProxy != null;
const RNPerformanceManager = isTurboModuleEnabled ? require('./NativeRNPerformanceManager').default : _reactNative.NativeModules.RNPerformanceManager;
if (_reactNative.Platform.OS === 'android' || RNPerformanceManager) {
  const emitter = new _reactNative.NativeEventEmitter(RNPerformanceManager);
  emitter.addListener('mark', data => {
    addEntry(new _performanceEntry.PerformanceReactNativeMark(data.name, data.startTime, data.detail));
  });
  emitter.addListener('metric', data => {
    addEntry(new _performanceEntry.PerformanceMetric(data.name, {
      startTime: data.startTime,
      value: data.value,
      detail: data.detail
    }));
  });
}
var _default = performance;
exports.default = _default;
const setResourceLoggingEnabled = function () {
  let enabled = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
  if (enabled) {
    //@ts-ignore
    (0, _resourceLogger.installResourceLogger)(globalThis, performance, addEntry);
  } else {
    (0, _resourceLogger.uninstallResourceLogger)(globalThis);
  }
};
exports.setResourceLoggingEnabled = setResourceLoggingEnabled;
//# sourceMappingURL=index.js.map