'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var React = _interopRequireWildcard(_react);

var _defaultComponentDecorator = require('../decorators/defaultComponentDecorator');

var _defaultComponentDecorator2 = _interopRequireDefault(_defaultComponentDecorator);

var _defaultHrefDecorator = require('../decorators/defaultHrefDecorator');

var _defaultHrefDecorator2 = _interopRequireDefault(_defaultHrefDecorator);

var _defaultMatchDecorator = require('../decorators/defaultMatchDecorator');

var _defaultMatchDecorator2 = _interopRequireDefault(_defaultMatchDecorator);

var _defaultTextDecorator = require('../decorators/defaultTextDecorator');

var _defaultTextDecorator2 = _interopRequireDefault(_defaultTextDecorator);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Linkify = function (_React$Component) {
  _inherits(Linkify, _React$Component);

  function Linkify() {
    _classCallCheck(this, Linkify);

    return _possibleConstructorReturn(this, (Linkify.__proto__ || Object.getPrototypeOf(Linkify)).apply(this, arguments));
  }

  _createClass(Linkify, [{
    key: 'parseString',
    value: function parseString(string) {
      var _this2 = this;

      if (string === '') {
        return string;
      }

      var matches = this.props.matchDecorator(string);
      if (!matches) {
        return string;
      }

      var elements = [];
      var lastIndex = 0;
      matches.forEach(function (match, i) {
        // Push preceding text if there is any
        if (match.index > lastIndex) {
          elements.push(string.substring(lastIndex, match.index));
        }

        var decoratedHref = _this2.props.hrefDecorator(match.url);
        var decoratedText = _this2.props.textDecorator(match.text);
        var decoratedComponent = _this2.props.componentDecorator(decoratedHref, decoratedText, i);
        elements.push(decoratedComponent);

        lastIndex = match.lastIndex;
      });

      // Push remaining text if there is any
      if (string.length > lastIndex) {
        elements.push(string.substring(lastIndex));
      }

      return elements.length === 1 ? elements[0] : elements;
    }
  }, {
    key: 'parse',
    value: function parse(children) {
      var _this3 = this;

      var key = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

      if (typeof children === 'string') {
        return this.parseString(children);
      } else if (React.isValidElement(children) && children.type !== 'a' && children.type !== 'button') {
        return React.cloneElement(children, { key: key }, this.parse(children.props.children));
      } else if (Array.isArray(children)) {
        return children.map(function (child, i) {
          return _this3.parse(child, i);
        });
      }

      return children;
    }
  }, {
    key: 'render',
    value: function render() {
      return React.createElement(
        React.Fragment,
        null,
        this.parse(this.props.children)
      );
    }
  }]);

  return Linkify;
}(React.Component);

Linkify.defaultProps = {
  componentDecorator: _defaultComponentDecorator2.default,
  hrefDecorator: _defaultHrefDecorator2.default,
  matchDecorator: _defaultMatchDecorator2.default,
  textDecorator: _defaultTextDecorator2.default
};
exports.default = Linkify;