"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.escapeStringToBeUsedInRegExp = escapeStringToBeUsedInRegExp;
exports.stripNonStringElements = stripNonStringElements;
exports.returnNonStringStrippedElements = returnNonStringStrippedElements;

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

var NON_STRING_PLACEHOLDER = "__REACT_EMOJI_RENDER_PLACEHOLDER__";

function escapeStringToBeUsedInRegExp(string) {
  return string.replace(/[.*+?^${}()|[\]\\]/g, "\\$&"); // $& means the whole matched string
}

function stripNonStringElements(children) {
  var strippedChildren = children.map(function (child) {
    return typeof child === "string" ? child : NON_STRING_PLACEHOLDER;
  }).join("");
  var elements = children.filter(function (child) {
    return typeof child !== "string";
  });
  return [strippedChildren, elements];
}

function flatMap(array, mapper) {
  var result = [];

  for (var i = 0; i < array.length; ++i) {
    var item = mapper(array[i], i, array);

    if (!Array.isArray(item)) {
      item = [item];
    }

    for (var j = 0; j < item.length; ++j) {
      result.push(item[j]);
    }
  }

  return result;
}

function returnNonStringStrippedElements(stripped, elements) {
  if (!stripped || !Array.isArray(stripped)) return stripped;
  if (!elements || !elements.length) return stripped;

  var count = -1;

  function replacePlaceholder(string) {
    var split = string.split(NON_STRING_PLACEHOLDER);
    if (split.length > 1) {
      return flatMap(split, function (item, index) {
        if (index === 0) return [item];else {
          count++;
          return [elements[count], item];
        }
      });
    } else {
      count++;
      return [].concat(_toConsumableArray(split), [elements[count]]);
    }
  }

  return flatMap(stripped, function (item) {
    if (typeof item === "string") {
      if (item.trim() === NON_STRING_PLACEHOLDER) {
        count++;
        return elements[count];
      } else if (item.includes(NON_STRING_PLACEHOLDER)) {
        return replacePlaceholder(item);
      }
    }
    return item;
  });
}