"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.toArray = toArray;
exports.default = Emoji;

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _propTypes = require("prop-types");

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames2 = require("classnames");

var _classnames3 = _interopRequireDefault(_classnames2);

var _stringReplaceToArray = require("string-replace-to-array");

var _stringReplaceToArray2 = _interopRequireDefault(_stringReplaceToArray);

var _emojiRegex = require("emoji-regex");

var _emojiRegex2 = _interopRequireDefault(_emojiRegex);

var _aliasRegex = require("./aliasRegex");

var _aliasRegex2 = _interopRequireDefault(_aliasRegex);

var _normalizeProtocol = require("./normalizeProtocol");

var _normalizeProtocol2 = _interopRequireDefault(_normalizeProtocol);

var _unicodeToCodepoint = require("./unicodeToCodepoint");

var _unicodeToCodepoint2 = _interopRequireDefault(_unicodeToCodepoint);

var _aliases = require("../data/aliases");

var _aliases2 = _interopRequireDefault(_aliases);

var _asciiAliases = require("../data/asciiAliases");

var _asciiAliases2 = _interopRequireDefault(_asciiAliases);

var _utils = require("./utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var unicodeEmojiRegex = (0, _emojiRegex2.default)();

// using em's we can ensure size matches surrounding font
var style = {
  width: "1em",
  height: "1em",
  margin: "0 .05em 0 .1em",
  verticalAlign: "-0.1em"
};

var asciiToAlias = { ":": ":" };

var _iteratorNormalCompletion = true;
var _didIteratorError = false;
var _iteratorError = undefined;

try {
  for (var _iterator = Object.keys(_asciiAliases2.default)[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
    var alias = _step.value;
    var _iteratorNormalCompletion2 = true;
    var _didIteratorError2 = false;
    var _iteratorError2 = undefined;

    try {
      for (var _iterator2 = _asciiAliases2.default[alias][Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
        var ascii = _step2.value;

        asciiToAlias[ascii] = _aliases2.default[alias];
      }
    } catch (err) {
      _didIteratorError2 = true;
      _iteratorError2 = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion2 && _iterator2.return) {
          _iterator2.return();
        }
      } finally {
        if (_didIteratorError2) {
          throw _iteratorError2;
        }
      }
    }
  }
} catch (err) {
  _didIteratorError = true;
  _iteratorError = err;
} finally {
  try {
    if (!_iteratorNormalCompletion && _iterator.return) {
      _iterator.return();
    }
  } finally {
    if (_didIteratorError) {
      throw _iteratorError;
    }
  }
}

function toArray(text) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  var protocol = (0, _normalizeProtocol2.default)(options.protocol);

  function replaceUnicodeEmoji(match, i) {
    if (!options.baseUrl) {
      return _react2.default.createElement(
        "span",
        { key: i, style: style, className: options.className },
        match
      );
    }

    var codepoint = (0, _unicodeToCodepoint2.default)(match, removeHelperCharacters);

    // if Emojione we don't want to add helper characters in the URL
    var removeHelperCharacters = options.emojione;
    if (removeHelperCharacters) {
      codepoint = codepoint.replace(/-200d/g, "").replace(/-fe0f/g, "");
    }

    var separator = options.size ? "/" : "";
    var src = "" + protocol + options.baseUrl + options.size + separator + codepoint + "." + options.ext;

    return _react2.default.createElement("img", _extends({
      key: i,
      alt: match,
      src: src,
      style: style,
      className: options.className
    }, options.props));
  }

  function replaceAliases(text) {
    var regex = (0, _aliasRegex2.default)();
    var textWithEmoji = [];
    var match = void 0,
        pos = 0;

    while (match = regex.exec(text)) {
      var _match$slice = match.slice(1, 4),
          _match$slice2 = _slicedToArray(_match$slice, 3),
          edgeCase = _match$slice2[0],
          asciiAlias = _match$slice2[1],
          fullEmoji = _match$slice2[2];
      // possible full emoji like :open_mouth:


      var emoji = _aliases2.default[(asciiAlias + fullEmoji).slice(1, -1)];
      if (match.index > pos) {
        // text between matches
        textWithEmoji.push(text.slice(pos, match.index));
      }
      if (edgeCase) {
        // verbatim matched text
        textWithEmoji.push(match[0]);
      } else if (asciiAlias[0] === ":" && fullEmoji && emoji) {
        // full emoji
        textWithEmoji.push(emoji);
      } else {
        // ascii alias or ":"
        textWithEmoji.push(asciiToAlias[asciiAlias]);
        if (fullEmoji) {
          // false positive, "go back" and don't skip that substring
          regex.lastIndex -= fullEmoji.length;
        }
      }
      pos = regex.lastIndex;
    }

    // text after last match (if any)
    textWithEmoji.push(text.slice(pos));
    return textWithEmoji.join("");
  }

  return (0, _stringReplaceToArray2.default)(replaceAliases(text), unicodeEmojiRegex, replaceUnicodeEmoji);
}

function Emoji(_ref) {
  var text = _ref.text,
      onlyEmojiClassName = _ref.onlyEmojiClassName,
      _ref$options = _ref.options,
      options = _ref$options === undefined ? {} : _ref$options,
      className = _ref.className,
      children = _ref.children,
      rest = _objectWithoutProperties(_ref, ["text", "onlyEmojiClassName", "options", "className", "children"]);

  var nonStringElements = [];

  if (!!children && Array.isArray(children)) {
    var _stripNonStringElemen = (0, _utils.stripNonStringElements)(children),
        _stripNonStringElemen2 = _slicedToArray(_stripNonStringElemen, 2),
        strippedChildren = _stripNonStringElemen2[0],
        elements = _stripNonStringElemen2[1];

    text = strippedChildren;
    nonStringElements = elements;
  } else if (!!children && typeof children === "string") {
    text = children;
  } else if (!!children) {
    //children must then be an object (react component or html element)
    var _stripNonStringElemen3 = (0, _utils.stripNonStringElements)([children]),
        _stripNonStringElemen4 = _slicedToArray(_stripNonStringElemen3, 2),
        _strippedChildren = _stripNonStringElemen4[0],
        _elements = _stripNonStringElemen4[1];

    text = _strippedChildren;
    nonStringElements = _elements;
  } else if (!text) {
    throw new Error("react-emoji-render: either children or text prop must be provided");
  }

  function isOnlyEmoji(output) {
    if (output.length > 3) return false;

    for (var i = 0; i < output.length; i++) {
      if (typeof output[i] === "string") return false;
    }

    return true;
  }

  var output = (0, _utils.returnNonStringStrippedElements)(toArray(text, options), nonStringElements);

  var classes = (0, _classnames3.default)(className, _defineProperty({}, onlyEmojiClassName, isOnlyEmoji(output)));

  return _react2.default.createElement(
    "span",
    _extends({}, rest, { className: classes }),
    output
  );
}

Emoji.propTypes = {
  text: _propTypes2.default.string,
  props: _propTypes2.default.object,
  onlyEmojiClassName: _propTypes2.default.string,
  options: _propTypes2.default.shape({
    baseUrl: _propTypes2.default.string,
    size: _propTypes2.default.oneOfType([_propTypes2.default.number, _propTypes2.default.string]),
    ext: _propTypes2.default.string,
    className: _propTypes2.default.string
  })
};