"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _asciiAliases = require("../data/asciiAliases");

var _asciiAliases2 = _interopRequireDefault(_asciiAliases);

var _lodash = require("lodash.flatten");

var _lodash2 = _interopRequireDefault(_lodash);

var _utils = require("./utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var allowedAliasCharacters = "\\w\\-\\_\\+\\*\\(\\)\\!#&åô’çéãí“”,";
var startOfURL = "https?\\S*";

var names = (0, _lodash2.default)(Object.keys(_asciiAliases2.default).map(function (name) {
  return _asciiAliases2.default[name].map(_utils.escapeStringToBeUsedInRegExp);
})).sort().reverse().join("|"); // reverse sort for most specific match

var edgeCases = [startOfURL].join("|");

function getAliasesRegex() {
  return new RegExp(
  // edge cases will be skipped
  // match both (and later distinguish between)
  // * ascii aliases like :o
  // * full emoji like :open_mouth:
  "(" + edgeCases + ")?(" + names + "|:)([" + allowedAliasCharacters + "]*:)?", "g");
}

exports.default = getAliasesRegex;