# node-matroska
Matroska library written for nodejs

# Fork of node-ebml
It is a fork of https://github.com/themasch/node-ebml

# VERY Fast parsing

Fast and incomplete parsing of a mkv file:   (we keep only metadatas)
```js
var matroska = require('matroska');

var url="http://download.wavetlan.com/SVV/Media/HTTP/mkv/H264_PCM(mkvmerge).mkv";

matroska.Decoder.parseInfoTagsAndAttachments(url, function(error, document) {
	if (error) {
		console.error(error);
		return;
	}

	console.log(document.print());
});
```

Returns a tree:  (format:  offset#tagId  * node)
````
         0#0     * Document  [HttpSource url=http://download.wavetlan.com/SVV/Media/HTTP/mkv/H264_PCM(mkvmerge).mkv]
         0#1       * EBML  children[size=40]
         5#2         * EBMLVersion  u[1]=1
         9#3         * EBMLReadVersion  u[1]=1
        13#4         * EBMLMaxIDLength  u[1]=4
        17#5         * EBMLMaxSizeLength  u[1]=8
        21#6         * DocType  s[8]='matroska'
        32#7         * DocTypeVersion  u[1]=2
        36#8         * DocTypeReadVersion  u[1]=2
        40#9       * Segment  children[size=40316440]
        52#10        * SeekHead  children[size=52]
        57#11          * Seek  children[size=15]
        60#12            * SeekID  b[4]=1549a966 => Info
        67#13            * SeekPosition  u[2]=4099  [=>#20]
        72#14          * Seek  children[size=15]
        75#15            * SeekID  b[4]=1654ae6b => Tracks
        82#16            * SeekPosition  u[2]=4248
        87#17          * Seek  children[size=17]
        90#18            * SeekID  b[4]=1c53bb6b => Cues
        97#19            * SeekPosition  u[4]=40315034
      4151#20        * Info  children[size=149]
      4157#21          * TimecodeScale  u[3]=1000000
      4164#22          * MuxingApp  8[35]='libebml v1.2.1 + libmatroska v1.1.1'
      4202#23          * WritingApp  8[58]='mkvmerge v4.9.1 ('Ich will') built on Jul 11 2011 23:53:15'
      4263#24          * Duration  f[4]=388000
      4270#25          * DateUTC  d[8]=Fri Sep 23 2011 00:33:39 GMT+0200 (Paris, Madrid (heure d’été))
      4281#26          * SegmentUID  b[16]=8e9c49d7b307eb148bd386041b43d6ca
```

# COMPLETE parsing

Complete parsing of a mkv:
```js
var matroska = require('matroska');

var url="http://download.wavetlan.com/SVV/Media/HTTP/mkv/H264_mp3(mkvmerge).mkv";

var decoder = new matroska.Decoder();
decoder.parse(url, function(error, document) {
	if (error) {
		console.error(error);
		return;
	}

	console.log(document.print());
});

```

Returns: 
```
         0#0     * Document  [FileSource file=G:\Downloads\H264_mp3(mkvmerge).mkv]
         0#1       * EBML  children[size=40]
         5#2         * EBMLVersion  u[1]=1
         9#3         * EBMLReadVersion  u[1]=1
        13#4         * EBMLMaxIDLength  u[1]=4
        17#5         * EBMLMaxSizeLength  u[1]=8
        21#6         * DocType  s[8]='matroska'
        32#7         * DocTypeVersion  u[1]=2
        36#8         * DocTypeReadVersion  u[1]=2
        40#9       * Segment  children[size=3661175]
        52#10        * SeekHead  children[size=51]
        57#11          * Seek  children[size=15]
        60#12            * SeekID  b[4]=1549a966 => Info
        67#13            * SeekPosition  u[2]=4099  [=>#21]
        72#14          * Seek  children[size=15]
        75#15            * SeekID  b[4]=1654ae6b => Tracks
        82#16            * SeekPosition  u[2]=4248  [=>#28]
        87#17          * Seek  children[size=16]
        90#18            * SeekID  b[4]=1c53bb6b => Cues
        97#19            * SeekPosition  u[3]=3660935  [=>#2109]
       103#20        * Void  b[4045]
      4151#21        * Info  children[size=149]
      4157#22          * TimecodeScale  u[3]=1000000
      4164#23          * MuxingApp  8[35]='libebml v1.2.1 + libmatroska v1.1.1'
      4202#24          * WritingApp  8[58]='mkvmerge v4.9.1 ('Ich will') built on Jul 11 2011 23:53:15'
      4263#25          * Duration  f[4]=69956
      4270#26          * DateUTC  d[8]=Fri Sep 23 2011 00:17:39 GMT+0200 (Paris, Madrid (heure d’été))
      4281#27          * SegmentUID  b[16]=bcb1c3b73d5109e98863c2955602b063
      4300#28        * Tracks  children[size=217]
      4306#29          * TrackEntry  children[size=142]
      4309#30            * TrackNumber  u[1]=1
      4312#31            * TrackUID  u[4]=644805295
      4319#32            * TrackType  u[1]=1
      4322#33            * FlagLacing  u[1]=0
      4325#34            * MinCache  u[1]=1
      4329#35            * CodecID  s[15]='V_MPEG4/ISO/AVC'
      4346#36            * CodecPrivate  b[43]=0142c00cffe1001c6742c00c9a740501edff807800c988000003000800000301
      4392#37            * DefaultDuration  u[4]=41666666
      4400#38            * Language  s[3]='und'
      4407#39            * Video  children[size=24]
      4409#40              * PixelWidth  u[2]=640
      4413#41              * PixelHeight  u[2]=480
      4417#42              * DisplayWidth  u[4]=640
      4424#43              * DisplayHeight  u[4]=806
      4431#44            * ContentEncodings  children[size=17]
      4434#45              * ContentEncoding  children[size=14]
      4437#46                * ContentCompression  children[size=11]
      4440#47                  * ContentCompAlgo  u[1]=3
      4444#48                  * ContentCompSettings  b[1]=00
      4448#49          * TrackEntry  children[size=69]
      4450#50            * TrackNumber  u[1]=2
      4453#51            * TrackUID  u[4]=1713889946
      4460#52            * TrackType  u[1]=2
      4463#53            * CodecID  s[9]='A_MPEG/L3'
      4474#54            * DefaultDuration  u[4]=26122448
      4482#55            * Language  s[3]='und'
      4489#56            * Audio  children[size=11]
      4491#57              * SamplingFrequency  f[4]=22050
      4497#58              * Channels  u[1]=2
      4500#59            * ContentEncodings  children[size=17]
      4503#60              * ContentEncoding  children[size=14]
      4506#61                * ContentCompression  children[size=11]
      4509#62                  * ContentCompAlgo  u[1]=3
      4513#63                  * ContentCompSettings  b[1]=ff
      4517#64        * Void  b[1108]
      5628#65        * Cluster  children[size=290112]
      5635#66          * Timecode  u[1]=0
      5638#67          * SimpleBlock  b[1439]
      7080#68          * SimpleBlock  b[4184]
     11267#69          * SimpleBlock  b[134]
     11404#70          * SimpleBlock  b[19]
     11425#71          * SimpleBlock  b[308]
     ...
    288918#206         * SimpleBlock  b[1573]
    290494#207         * SimpleBlock  b[5243]
    295740#208       * Cluster  children[size=246364]
    295747#209         * Timecode  u[2]=4875
    295751#210         * SimpleBlock  b[2613]
      ...
   3397072#1958        * SimpleBlock  b[2136]
   3399211#1959      * Cluster  children[size=259667]
   3399218#1960        * Timecode  u[2]=64833
   3399222#1961        * SimpleBlock  b[3913]
      ...
   3657216#2101        * SimpleBlock  b[148]
   3657367#2102        * SimpleBlock  b[1268]
   3658638#2103        * BlockGroup  children[size=240]
   3658641#2104          * Block  b[231]
   3658875#2105          * ReferenceBlock  i[1]=-42
   3658878#2106      * Cluster  children[size=2109]
   3658884#2107        * Timecode  u[3]=69851
   3658889#2108        * SimpleBlock  b[2095]
   3660987#2109      * Cues  children[size=228]
   3660993#2110        * CuePoint  children[size=14]
   3660995#2111          * CueTime  u[1]=0
   3660998#2112          * CueTrackPositions  children[size=9]
   3661000#2113            * CueTrack  u[1]=1
   3661003#2114            * CueClusterPosition  u[2]=5576  [=>#65]
   3661007#2115        * CuePoint  children[size=16]
   3661009#2116          * CueTime  u[2]=4875
   3661013#2117          * CueTrackPositions  children[size=10]
   3661015#2118            * CueTrack  u[1]=1
   3661018#2119            * CueClusterPosition  u[3]=295688  [=>#208]
   ...
   3661199#2175        * CuePoint  children[size=16]
   3661201#2176          * CueTime  u[2]=64833
   3661205#2177          * CueTrackPositions  children[size=10]
   3661207#2178            * CueTrack  u[1]=1
   3661210#2179            * CueClusterPosition  u[3]=3399159  [=>#1959]

```

# Edition of MKV

... it works, samples soon :-)
