module.exports = {
  byEbmlID: {
    0x80: {
      name: 'ChapterDisplay',
      level: 4,
      type: 'm',
      multiple: true,
      webm: true,
      description: 'Contains all possible strings to use for the chapter display.',
      minver: 1,
      crc: false
    },
    0x83: {
      name: 'TrackType',
      level: 3,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'The `TrackType` defines the type of each frame found in the Track. The value **SHOULD** be stored on 1 octet.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x85: {
      name: 'ChapString',
      level: 5,
      type: '8',
      multiple: false,
      webm: true,
      description: 'Contains the string to use as the chapter atom.',
      mandatory: true,
      cppname: 'ChapterString',
      minver: 1,
      crc: false
    },
    0x86: {
      name: 'CodecID',
      level: 3,
      type: 's',
      multiple: false,
      webm: true,
      description: 'An ID corresponding to the codec, see [@?MatroskaCodec] for more info.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x88: {
      name: 'FlagDefault',
      level: 3,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Set if that track (audio, video or subs) is eligible for automatic selection by the player; see (#default-track-selection) for more details.',
      mandatory: true,
      range: '0-1',
      cppname: 'TrackFlagDefault',
      minver: 1,
      default: '1',
      crc: false
    },
    0x89: {
      name: 'ChapterTrackUID',
      level: 5,
      type: 'u',
      multiple: true,
      description: 'UID of the Track to apply this chapter to. In the absence of a control track, choosing this chapter will select the listed Tracks and deselect unlisted tracks. Absence of this Element indicates that the Chapter **SHOULD** be applied to any currently used Tracks.',
      mandatory: true,
      range: 'not 0',
      cppname: 'ChapterTrackNumber',
      minver: 1,
      crc: false
    },
    0x8e: {
      name: 'Slices',
      level: 3,
      type: 'm',
      multiple: false,
      description: 'Contains slices description.',
      minver: 0,
      maxver: 0,
      crc: false
    },
    0x8f: {
      name: 'ChapterTrack',
      level: 4,
      type: 'm',
      multiple: false,
      description: 'List of tracks on which the chapter applies. If this Element is not present, all tracks apply',
      minver: 1,
      crc: false
    },
    0x91: {
      name: 'ChapterTimeStart',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Timestamp of the start of Chapter, expressed in Matroska Ticks -- i.e., in nanoseconds; see (#timestamp-ticks).',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x92: {
      name: 'ChapterTimeEnd',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Timestamp of the end of Chapter timestamp excluded, expressed in Matroska Ticks -- i.e., in nanoseconds; see (#timestamp-ticks). The value **MUST** be greater than or equal to the `ChapterTimeStart` of the same `ChapterAtom`.',
      minver: 1,
      crc: false
    },
    0x96: {
      name: 'CueRefTime',
      level: 5,
      type: 'u',
      multiple: false,
      description: 'Timestamp of the referenced Block, expressed in Matroska Ticks -- i.e., in nanoseconds; see (#timestamp-ticks).',
      mandatory: true,
      minver: 2,
      crc: false
    },
    0x97: {
      name: 'CueRefCluster',
      level: 5,
      type: 'u',
      multiple: false,
      description: 'The Segment Position of the Cluster containing the referenced Block.',
      mandatory: true,
      minver: 0,
      maxver: 0,
      crc: false
    },
    0x98: {
      name: 'ChapterFlagHidden',
      level: 4,
      type: 'u',
      multiple: false,
      description: 'Set to 1 if a chapter is hidden. Hidden chapters **SHOULD NOT** be available to the user interface (but still to Control Tracks; see (#chapterflaghidden) on Chapter flags).',
      mandatory: true,
      range: '0-1',
      minver: 1,
      default: '0',
      crc: false
    },
    0x9a: {
      name: 'FlagInterlaced',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Specify whether the video frames in this track are interlaced.',
      mandatory: true,
      cppname: 'VideoFlagInterlaced',
      minver: 2,
      default: '0',
      crc: false
    },
    0x9b: {
      name: 'BlockDuration',
      level: 3,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'The duration of the Block, expressed in Track Ticks; see (#timestamp-ticks). The BlockDuration Element can be useful at the end of a Track to define the duration of the last frame (as there is no subsequent Block available), or when there is a break in a track like for subtitle tracks.',
      minver: 1,
      crc: false
    },
    0x9c: {
      name: 'FlagLacing',
      level: 3,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Set to 1 if the track **MAY** contain blocks using lacing. When set to 0 all blocks **MUST** have their lacing flags set to No lacing; see (#block-lacing) on Block Lacing.',
      mandatory: true,
      range: '0-1',
      cppname: 'TrackFlagLacing',
      minver: 1,
      default: '1',
      crc: false
    },
    0x9d: {
      name: 'FieldOrder',
      level: 4,
      type: 'u',
      multiple: false,
      description: 'Specify the field ordering of video frames in this track.',
      mandatory: true,
      cppname: 'VideoFieldOrder',
      minver: 4,
      default: '2',
      crc: false
    },
    0x9f: {
      name: 'Channels',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Numbers of channels in the track.',
      mandatory: true,
      range: 'not 0',
      cppname: 'AudioChannels',
      minver: 1,
      default: '1',
      crc: false
    },
    0xa0: {
      name: 'BlockGroup',
      level: 2,
      type: 'm',
      multiple: true,
      webm: true,
      description: 'Basic container of information containing a single Block and information specific to that Block.',
      minver: 1,
      crc: false
    },
    0xa1: {
      name: 'Block',
      level: 3,
      type: 'b',
      multiple: false,
      webm: true,
      description: 'Block containing the actual data to be rendered and a timestamp relative to the Cluster Timestamp; see (#block-structure) on Block Structure.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0xa2: {
      name: 'BlockVirtual',
      level: 3,
      type: 'b',
      multiple: false,
      description: 'A Block with no data. It must be stored in the stream at the place the real Block would be in display order. ',
      minver: 0,
      maxver: 0,
      crc: false
    },
    0xa3: {
      name: 'SimpleBlock',
      level: 2,
      type: 'b',
      multiple: true,
      webm: true,
      description: 'Similar to Block, see (#block-structure), but without all the extra information, mostly used to reduced overhead when no extra feature is needed; see (#simpleblock-structure) on SimpleBlock Structure.',
      minver: 2,
      divx: true,
      crc: false
    },
    0xa4: {
      name: 'CodecState',
      level: 3,
      type: 'b',
      multiple: false,
      description: 'The new codec state to use. Data interpretation is private to the codec. This information **SHOULD** always be referenced by a seek entry.',
      minver: 2,
      crc: false
    },
    0xa5: {
      name: 'BlockAdditional',
      level: 5,
      type: 'b',
      multiple: false,
      webm: true,
      description: 'Interpreted by the codec as it wishes (using the BlockAddID).',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0xa6: {
      name: 'BlockMore',
      level: 4,
      type: 'm',
      multiple: true,
      webm: true,
      description: 'Contain the BlockAdditional and some parameters.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0xa7: {
      name: 'Position',
      level: 2,
      type: 'u',
      multiple: false,
      description: 'The Segment Position of the Cluster in the Segment (0 in live streams). It might help to resynchronise offset on damaged streams.',
      cppname: 'ClusterPosition',
      minver: 1,
      maxver: 4,
      crc: false
    },
    0xaa: {
      name: 'CodecDecodeAll',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'Set to 1 if the codec can decode potentially damaged data.',
      mandatory: true,
      range: '0-1',
      minver: 1,
      maxver: 0,
      default: '1',
      crc: false
    },
    0xab: {
      name: 'PrevSize',
      level: 2,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Size of the previous Cluster, in octets. Can be useful for backward playing.',
      cppname: 'ClusterPrevSize',
      minver: 1,
      crc: false
    },
    0xae: {
      name: 'TrackEntry',
      level: 2,
      type: 'm',
      multiple: true,
      webm: true,
      description: 'Describes a track with all Elements.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0xaf: {
      name: 'EncryptedBlock',
      level: 2,
      type: 'b',
      multiple: true,
      description: 'Similar to SimpleBlock, see (#simpleblock-structure), but the data inside the Block are Transformed (encrypt and/or signed).',
      minver: 0,
      maxver: 0,
      crc: false
    },
    0xb0: {
      name: 'PixelWidth',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Width of the encoded video frames in pixels.',
      mandatory: true,
      range: 'not 0',
      cppname: 'VideoPixelWidth',
      minver: 1,
      crc: false
    },
    0xb2: {
      name: 'CueDuration',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: "The duration of the block, expressed in Segment Ticks which is based on TimestampScale; see (#timestamp-ticks). If missing, the track's DefaultDuration does not apply and no duration information is available in terms of the cues.",
      minver: 4,
      crc: false
    },
    0xb3: {
      name: 'CueTime',
      level: 3,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Absolute timestamp of the seek point, expressed in Matroska Ticks -- i.e., in nanoseconds; see (#timestamp-ticks).',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0xb5: {
      name: 'SamplingFrequency',
      level: 4,
      type: 'f',
      multiple: false,
      webm: true,
      description: 'Sampling frequency in Hz.',
      mandatory: true,
      range: '> 0x0p+0',
      cppname: 'AudioSamplingFreq',
      minver: 1,
      default: '0x1.f4p+12',
      crc: false
    },
    0xb6: {
      name: 'ChapterAtom',
      level: 3,
      type: 'm',
      multiple: true,
      webm: true,
      description: 'Contains the atom information to use as the chapter atom (apply to all tracks).',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0xb7: {
      name: 'CueTrackPositions',
      level: 3,
      type: 'm',
      multiple: true,
      webm: true,
      description: 'Contain positions for different tracks corresponding to the timestamp.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0xb9: {
      name: 'FlagEnabled',
      level: 3,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Set to 1 if the track is usable. It is possible to turn a not usable track into a usable track using chapter codecs or control tracks.',
      mandatory: true,
      range: '0-1',
      cppname: 'TrackFlagEnabled',
      minver: 2,
      default: '1',
      crc: false
    },
    0xba: {
      name: 'PixelHeight',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Height of the encoded video frames in pixels.',
      mandatory: true,
      range: 'not 0',
      cppname: 'VideoPixelHeight',
      minver: 1,
      crc: false
    },
    0xbb: {
      name: 'CuePoint',
      level: 2,
      type: 'm',
      multiple: true,
      webm: true,
      description: 'Contains all information relative to a seek point in the Segment.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0xbf: {
      name: 'CRC-32',
      level: -1,
      type: 'b',
      multiple: true,
      description: "The CRC is computed on all the data of the Master element it's in. The CRC element should be the first in it's parent master for easier reading. All level 1 elements should include a CRC-32. The CRC in use is the IEEE CRC32 Little Endian.",
      minver: 1,
      crc: true,
      webm: false
    },
    0xc0: {
      name: 'TrickTrackUID',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'The TrackUID of the Smooth FF/RW video in the paired EBML structure corresponding to this video track. See [@?DivXTrickTrack].',
      minver: 0,
      maxver: 0,
      divx: true,
      crc: false
    },
    0xc1: {
      name: 'TrickTrackSegmentUID',
      level: 3,
      type: 'b',
      multiple: false,
      description: 'The SegmentUID of the Segment containing the track identified by TrickTrackUID. See [@?DivXTrickTrack].',
      minver: 0,
      maxver: 0,
      divx: true,
      crc: false
    },
    0xc4: {
      name: 'TrickMasterTrackSegmentUID',
      level: 3,
      type: 'b',
      multiple: false,
      description: 'The SegmentUID of the Segment containing the track identified by MasterTrackUID. See [@?DivXTrickTrack].',
      minver: 0,
      maxver: 0,
      divx: true,
      crc: false
    },
    0xc6: {
      name: 'TrickTrackFlag',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'Set to 1 if this video track is a Smooth FF/RW track. If set to 1, MasterTrackUID and MasterTrackSegUID should must be present and BlockGroups for this track must contain ReferenceFrame structures. Otherwise, TrickTrackUID and TrickTrackSegUID must be present if this track has a corresponding Smooth FF/RW track. See [@?DivXTrickTrack].',
      minver: 0,
      maxver: 0,
      default: '0',
      divx: true,
      crc: false
    },
    0xc7: {
      name: 'TrickMasterTrackUID',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'The TrackUID of the video track in the paired EBML structure that corresponds to this Smooth FF/RW track. See [@?DivXTrickTrack].',
      minver: 0,
      maxver: 0,
      divx: true,
      crc: false
    },
    0xc8: {
      name: 'ReferenceFrame',
      level: 3,
      type: 'm',
      multiple: false,
      description: 'Contains information about the last reference frame. See [@?DivXTrickTrack].',
      minver: 0,
      maxver: 0,
      divx: true,
      crc: false
    },
    0xc9: {
      name: 'ReferenceOffset',
      level: 4,
      type: 'u',
      multiple: false,
      description: 'The relative offset, in bytes, from the previous BlockGroup element for this Smooth FF/RW video track to the containing BlockGroup element. See [@?DivXTrickTrack].',
      mandatory: true,
      minver: 0,
      maxver: 0,
      divx: true,
      crc: false
    },
    0xca: {
      name: 'ReferenceTimestamp',
      level: 4,
      type: 'u',
      multiple: false,
      description: 'The timestamp of the BlockGroup pointed to by ReferenceOffset, expressed in Track Ticks; see (#timestamp-ticks). See [@?DivXTrickTrack].',
      mandatory: true,
      cppname: 'ReferenceTimeCode',
      minver: 0,
      maxver: 0,
      divx: true,
      crc: false
    },
    0xcb: {
      name: 'BlockAdditionID',
      level: 5,
      type: 'u',
      multiple: false,
      description: 'The ID of the BlockAdditional Element (0 is the main Block).',
      cppname: 'SliceBlockAddID',
      minver: 0,
      maxver: 0,
      default: '0',
      crc: false
    },
    0xcc: {
      name: 'LaceNumber',
      level: 5,
      type: 'u',
      multiple: false,
      description: 'The reverse number of the frame in the lace (0 is the last frame, 1 is the next to last, etc.). Being able to interpret this Element is not required for playback.',
      cppname: 'SliceLaceNumber',
      minver: 0,
      maxver: 0,
      crc: false
    },
    0xcd: {
      name: 'FrameNumber',
      level: 5,
      type: 'u',
      multiple: false,
      description: 'The number of the frame to generate from this lace with this delay (allow you to generate many frames from the same Block/Frame).',
      cppname: 'SliceFrameNumber',
      minver: 0,
      maxver: 0,
      default: '0',
      crc: false
    },
    0xce: {
      name: 'Delay',
      level: 5,
      type: 'u',
      multiple: false,
      description: 'The delay to apply to the Element, expressed in Track Ticks; see (#timestamp-ticks).',
      cppname: 'SliceDelay',
      minver: 0,
      maxver: 0,
      default: '0',
      crc: false
    },
    0xcf: {
      name: 'SliceDuration',
      level: 5,
      type: 'u',
      multiple: false,
      description: 'The duration to apply to the Element, expressed in Track Ticks; see (#timestamp-ticks).',
      minver: 0,
      maxver: 0,
      default: '0',
      crc: false
    },
    0xd7: {
      name: 'TrackNumber',
      level: 3,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'The track number as used in the Block Header.',
      mandatory: true,
      range: 'not 0',
      minver: 1,
      crc: false
    },
    0xdb: {
      name: 'CueReference',
      level: 4,
      type: 'm',
      multiple: true,
      description: 'The Clusters containing the referenced Blocks.',
      minver: 2,
      crc: false
    },
    0xe0: {
      name: 'Video',
      level: 3,
      type: 'm',
      multiple: false,
      webm: true,
      description: 'Video settings.',
      cppname: 'TrackVideo',
      minver: 1,
      crc: false
    },
    0xe1: {
      name: 'Audio',
      level: 3,
      type: 'm',
      multiple: false,
      webm: true,
      description: 'Audio settings.',
      cppname: 'TrackAudio',
      minver: 1,
      crc: false
    },
    0xe2: {
      name: 'TrackOperation',
      level: 3,
      type: 'm',
      multiple: false,
      description: 'Operation that needs to be applied on tracks to create this virtual track. For more details look at (#track-operation).',
      minver: 3,
      crc: false
    },
    0xe3: {
      name: 'TrackCombinePlanes',
      level: 4,
      type: 'm',
      multiple: false,
      description: 'Contains the list of all video plane tracks that need to be combined to create this 3D track',
      minver: 3,
      crc: false
    },
    0xe4: {
      name: 'TrackPlane',
      level: 5,
      type: 'm',
      multiple: true,
      description: 'Contains a video plane track that need to be combined to create this 3D track',
      mandatory: true,
      minver: 3,
      crc: false
    },
    0xe5: {
      name: 'TrackPlaneUID',
      level: 6,
      type: 'u',
      multiple: false,
      description: 'The trackUID number of the track representing the plane.',
      mandatory: true,
      range: 'not 0',
      minver: 3,
      crc: false
    },
    0xe6: {
      name: 'TrackPlaneType',
      level: 6,
      type: 'u',
      multiple: false,
      description: 'The kind of plane this track corresponds to.',
      mandatory: true,
      minver: 3,
      crc: false
    },
    0xe7: {
      name: 'Timestamp',
      level: 2,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Absolute timestamp of the cluster, expressed in Segment Ticks which is based on TimestampScale; see (#timestamp-ticks).',
      mandatory: true,
      cppname: 'ClusterTimecode',
      minver: 1,
      crc: false
    },
    0xe8: {
      name: 'TimeSlice',
      level: 4,
      type: 'm',
      multiple: true,
      description: 'Contains extra time information about the data contained in the Block. Being able to interpret this Element is not required for playback.',
      minver: 0,
      maxver: 0,
      crc: false
    },
    0xe9: {
      name: 'TrackJoinBlocks',
      level: 4,
      type: 'm',
      multiple: false,
      description: 'Contains the list of all tracks whose Blocks need to be combined to create this virtual track',
      minver: 3,
      crc: false
    },
    0xea: {
      name: 'CueCodecState',
      level: 4,
      type: 'u',
      multiple: false,
      description: 'The Segment Position ((#segment-position)) of the Codec State corresponding to this Cue Element. 0 means that the data is taken from the initial Track Entry.',
      mandatory: true,
      minver: 2,
      default: '0',
      crc: false
    },
    0xeb: {
      name: 'CueRefCodecState',
      level: 5,
      type: 'u',
      multiple: false,
      description: 'The Segment Position of the Codec State corresponding to this referenced Element. 0 means that the data is taken from the initial Track Entry.',
      minver: 0,
      maxver: 0,
      default: '0',
      crc: false
    },
    0xec: {
      name: 'Void',
      level: -1,
      type: 'b',
      multiple: true,
      description: 'Used to void damaged data, to avoid unexpected behaviors when using damaged data. The content is discarded. Also used to reserve space in a sub-element for later use.',
      minver: 1,
      crc: false
    },
    0xed: {
      name: 'TrackJoinUID',
      level: 5,
      type: 'u',
      multiple: true,
      description: 'The trackUID number of a track whose blocks are used to create this virtual track.',
      mandatory: true,
      range: 'not 0',
      minver: 3,
      crc: false
    },
    0xee: {
      name: 'BlockAddID',
      level: 5,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'An ID to identify how to interpret the BlockAdditional data; see Codec BlockAdditions section of [@?MatroskaCodec] for more information. A value of 1 indicates that the meaning of the BlockAdditional data is defined by the codec. Any other value indicates the meaning of the BlockAdditional data is found in the BlockAddIDType found in the TrackEntry.',
      mandatory: true,
      range: 'not 0',
      minver: 1,
      default: '1',
      crc: false
    },
    0xf0: {
      name: 'CueRelativePosition',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'The relative position inside the Cluster of the referenced SimpleBlock or BlockGroup with 0 being the first possible position for an Element inside that Cluster.',
      minver: 4,
      crc: false
    },
    0xf1: {
      name: 'CueClusterPosition',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'The Segment Position ((#segment-position)) of the Cluster containing the associated Block.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0xf7: {
      name: 'CueTrack',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'The track for which a position is given.',
      mandatory: true,
      range: 'not 0',
      minver: 1,
      crc: false
    },
    0xfa: {
      name: 'ReferencePriority',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'This frame is referenced and has the specified cache priority. In cache only a frame of the same or higher priority can replace this frame. A value of 0 means the frame is not referenced.',
      mandatory: true,
      minver: 1,
      default: '0',
      crc: false
    },
    0xfb: {
      name: 'ReferenceBlock',
      level: 3,
      type: 'i',
      multiple: true,
      webm: true,
      description: 'A timestamp value, relative to the timestamp of the Block in this BlockGroup, expressed in Track Ticks; see (#timestamp-ticks). This is used to reference other frames necessary to decode this frame. The relative value **SHOULD** correspond to a valid `Block` this `Block` depends on. Historically Matroska Writer didn\'t write the actual `Block(s)` this `Block` depends on, but *some* `Block` in the past.  The value "0" **MAY** also be used to signify this `Block` cannot be decoded on its own, but without knownledge of which `Block` is necessary. In this case, other `ReferenceBlock` **MUST NOT** be found in the same `BlockGroup`.  If the `BlockGroup` doesn\'t have any `ReferenceBlock` element, then the `Block` it contains can be decoded without using any other `Block` data.',
      minver: 1,
      crc: false
    },
    0xfd: {
      name: 'ReferenceVirtual',
      level: 3,
      type: 'i',
      multiple: false,
      description: 'The Segment Position of the data that would otherwise be in position of the virtual block.',
      minver: 0,
      maxver: 0,
      crc: false
    },
    0x41a4: {
      name: 'BlockAddIDName',
      level: 4,
      type: 's',
      multiple: false,
      description: 'A human-friendly name describing the type of BlockAdditional data, as defined by the associated Block Additional Mapping.',
      minver: 4,
      crc: false
    },
    0x41e4: {
      name: 'BlockAdditionMapping',
      level: 3,
      type: 'm',
      multiple: true,
      description: 'Contains elements that extend the track format, by adding content either to each frame, with BlockAddID ((#blockaddid-element)), or to the track as a whole with BlockAddIDExtraData.',
      minver: 4,
      crc: false
    },
    0x41e7: {
      name: 'BlockAddIDType',
      level: 4,
      type: 'u',
      multiple: false,
      description: 'Stores the registered identifier of the Block Additional Mapping to define how the BlockAdditional data should be handled.',
      mandatory: true,
      minver: 4,
      default: '0',
      crc: false
    },
    0x41ed: {
      name: 'BlockAddIDExtraData',
      level: 4,
      type: 'b',
      multiple: false,
      description: 'Extra binary data that the BlockAddIDType can use to interpret the BlockAdditional data. The interpretation of the binary data depends on the BlockAddIDType value and the corresponding Block Additional Mapping.',
      minver: 4,
      crc: false
    },
    0x41f0: {
      name: 'BlockAddIDValue',
      level: 4,
      type: 'u',
      multiple: false,
      description: 'If the track format extension needs content beside frames, the value refers to the BlockAddID ((#blockaddid-element)), value being described.',
      range: '>=2',
      minver: 4,
      crc: false
    },
    0x4254: {
      name: 'ContentCompAlgo',
      level: 6,
      type: 'u',
      multiple: false,
      description: 'The compression algorithm used.',
      mandatory: true,
      minver: 1,
      default: '0',
      crc: false
    },
    0x4255: {
      name: 'ContentCompSettings',
      level: 6,
      type: 'b',
      multiple: false,
      description: 'Settings that might be needed by the decompressor. For Header Stripping (`ContentCompAlgo`=3), the bytes that were removed from the beginning of each frames of the track.',
      minver: 1,
      crc: false
    },
    0x4281: {
      name: 'DocTypeExtension',
      level: 1,
      type: 'm',
      multiple: true,
      description: "A DocTypeExtension adds extra Elements to the main DocType+DocTypeVersion\ttuple it's attached to. An EBML Reader **MAY** know these extra Elements and how to use them. A DocTypeExtension **MAY** be used to iterate between\texperimental Elements before they are integrated into a regular\tDocTypeVersion. Reading one DocTypeExtension version of a DocType+DocTypeVersion tuple doesn't imply one should be able to read upper versions of this DocTypeExtension.",
      minver: 1,
      crc: false
    },
    0x4282: {
      name: 'DocType',
      level: 1,
      type: 's',
      multiple: true,
      description: "A string that describes the type of document that follows this EBML header, for example 'matroska' or 'webm'.",
      mandatory: true,
      minver: 1,
      crc: false,
      default: 'matroska'
    },
    0x4283: {
      name: 'DocTypeExtensionName',
      level: 2,
      type: 's',
      multiple: false,
      description: 'The name of the DocTypeExtension to differentiate it from other DocTypeExtensions of the same DocType+DocTypeVersion tuple. A DocTypeExtensionName value **MUST** be unique within the EBML Header.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x4284: {
      name: 'DocTypeExtensionVersion',
      level: 2,
      type: 'u',
      multiple: false,
      description: 'The version of the DocTypeExtension. Different DocTypeExtensionVersion values of the same DocType + DocTypeVersion + DocTypeExtensionName tuple **MAY** contain completely different sets of extra Elements. An EBML Reader **MAY** support multiple versions\tof the same tuple, only one version of the tuple, or not support the tuple at all.',
      mandatory: true,
      range: 'not 0',
      minver: 1,
      crc: false
    },
    0x4285: {
      name: 'DocTypeReadVersion',
      level: 1,
      type: 'u',
      multiple: false,
      description: 'The minimum DocType version an interpreter has to support to read this file.',
      mandatory: true,
      range: 'not 0',
      minver: 1,
      default: '1',
      crc: false
    },
    0x4286: {
      name: 'EBMLVersion',
      level: 1,
      type: 'u',
      multiple: false,
      description: 'The version of EBML parser used to create the file.',
      mandatory: true,
      range: 'not 0',
      minver: 1,
      default: '1',
      crc: false
    },
    0x4287: {
      name: 'DocTypeVersion',
      level: 1,
      type: 'u',
      multiple: false,
      description: 'The version of DocType interpreter used to create the file.',
      mandatory: true,
      range: 'not 0',
      minver: 1,
      default: '1',
      crc: false
    },
    0x42f2: {
      name: 'EBMLMaxIDLength',
      level: 1,
      type: 'u',
      multiple: false,
      mandatory: true,
      range: '>=4',
      minver: 1,
      default: '4',
      crc: false,
      description: "The maximum length of the IDs you'll find in this file (4 or less in Matroska)."
    },
    0x42f3: {
      name: 'EBMLMaxSizeLength',
      level: 1,
      type: 'u',
      multiple: false,
      mandatory: true,
      range: 'not 0',
      minver: 1,
      default: '8',
      crc: false,
      description: "The maximum length of the sizes you'll find in this file (8 or less in Matroska). This does not override the element size indicated at the beginning of an element. Elements that have an indicated size which is larger than what is allowed by EBMLMaxSizeLength shall be considered invalid."
    },
    0x42f7: {
      name: 'EBMLReadVersion',
      level: 1,
      type: 'u',
      multiple: false,
      description: 'The minimum EBML version a parser has to support to read this file.',
      mandatory: true,
      range: '1',
      minver: 1,
      default: '1',
      crc: false
    },
    0x437c: {
      name: 'ChapLanguage',
      level: 5,
      type: 's',
      multiple: true,
      webm: true,
      description: 'A language corresponding to the string, in the Matroska languages form; see (#language-codes) on language codes. This Element **MUST** be ignored if a ChapLanguageBCP47 Element is used within the same ChapterDisplay Element.',
      mandatory: true,
      cppname: 'ChapterLanguage',
      minver: 1,
      default: 'eng',
      crc: false
    },
    0x437d: {
      name: 'ChapLanguageBCP47',
      level: 5,
      type: 's',
      multiple: true,
      description: 'A language corresponding to the ChapString, in the [@!BCP47] form; see (#language-codes) on language codes. If a ChapLanguageBCP47 Element is used, then any ChapLanguage and ChapCountry Elements used in the same ChapterDisplay **MUST** be ignored.',
      cppname: 'ChapLanguageIETF',
      minver: 4,
      crc: false
    },
    0x437e: {
      name: 'ChapCountry',
      level: 5,
      type: 's',
      multiple: true,
      webm: true,
      description: 'A country corresponding to the string, in the Matroska countries form; see (#country-codes) on country codes. This Element **MUST** be ignored if a ChapLanguageBCP47 Element is used within the same ChapterDisplay Element.',
      cppname: 'ChapterCountry',
      minver: 1,
      crc: false
    },
    0x4444: {
      name: 'SegmentFamily',
      level: 2,
      type: 'b',
      multiple: true,
      description: 'A unique ID that all Segments of a Linked Segment **MUST** share (128 bits). It is equivalent to a UUID v4 [@!RFC4122] with all bits randomly (or pseudo-randomly) chosen. An actual UUID v4 value, where some bits are not random, **MAY** also be used.',
      minver: 1,
      crc: false
    },
    0x4461: {
      name: 'DateUTC',
      level: 2,
      type: 'd',
      multiple: false,
      webm: true,
      description: 'The date and time that the Segment was created by the muxing application or library.',
      minver: 1,
      crc: false
    },
    0x447a: {
      name: 'TagLanguage',
      level: 4,
      type: 's',
      multiple: false,
      webm: true,
      description: 'Specifies the language of the tag specified, in the Matroska languages form; see (#language-codes) on language codes. This Element **MUST** be ignored if the TagLanguageBCP47 Element is used within the same SimpleTag Element.',
      mandatory: true,
      cppname: 'TagLangue',
      minver: 1,
      default: 'und',
      crc: false
    },
    0x447b: {
      name: 'TagLanguageBCP47',
      level: 4,
      type: 's',
      multiple: false,
      description: 'The language used in the TagString, in the [@!BCP47] form; see (#language-codes) on language codes. If this Element is used, then any TagLanguage Elements used in the same SimpleTag **MUST** be ignored.',
      cppname: 'TagLanguageIETF',
      minver: 4,
      crc: false
    },
    0x4484: {
      name: 'TagDefault',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'A boolean value to indicate if this is the default/original language to use for the given tag.',
      mandatory: true,
      range: '0-1',
      minver: 1,
      default: '1',
      crc: false
    },
    0x4485: {
      name: 'TagBinary',
      level: 4,
      type: 'b',
      multiple: false,
      webm: true,
      description: 'The values of the Tag, if it is binary. Note that this cannot be used in the same SimpleTag as TagString.',
      minver: 1,
      crc: false
    },
    0x4487: {
      name: 'TagString',
      level: 4,
      type: '8',
      multiple: false,
      webm: true,
      description: 'The value of the Tag.',
      minver: 1,
      crc: false
    },
    0x4489: {
      name: 'Duration',
      level: 2,
      type: 'f',
      multiple: false,
      webm: true,
      description: 'Duration of the Segment, expressed in Segment Ticks which is based on TimestampScale; see (#timestamp-ticks).',
      range: '> 0x0p+0',
      minver: 1,
      crc: false
    },
    0x44b4: {
      name: 'TagDefaultBogus',
      level: 4,
      type: 'u',
      multiple: false,
      description: 'A variant of the TagDefault element with a bogus Element ID; see (#tagdefault-element).',
      mandatory: true,
      range: '0-1',
      minver: 0,
      maxver: 0,
      default: '1',
      crc: false
    },
    0x450d: {
      name: 'ChapProcessPrivate',
      level: 5,
      type: 'b',
      multiple: false,
      description: 'Some optional data attached to the ChapProcessCodecID information. For ChapProcessCodecID = 1, it is the "DVD level" equivalent; see (#menu-features) on DVD menus.',
      cppname: 'ChapterProcessPrivate',
      minver: 1,
      crc: false
    },
    0x4520: {
      name: 'EditionDisplay',
      level: 3,
      type: 'm',
      multiple: true,
      description: 'Contains a possible string to use for the edition display for the given languages.',
      minver: 5,
      crc: false
    },
    0x4521: {
      name: 'EditionString',
      level: 4,
      type: '8',
      multiple: false,
      description: 'Contains the string to use as the edition name.',
      mandatory: true,
      minver: 5,
      crc: false
    },
    0x4588: {
      name: 'ChapterSkipType',
      level: 4,
      type: 'u',
      multiple: false,
      webm: false,
      description: "Indicate what type of content the ChapterAtom contains and might be skipped. It can be used to automatically skip content based on the type. If a `ChapterAtom` is inside a `ChapterAtom` that has a `ChapterSkipType` set, it **MUST NOT** have a `ChapterSkipType` or have a `ChapterSkipType` with the same value as it's parent `ChapterAtom`. If the `ChapterAtom` doesn't contain a `ChapterTimeEnd`, the value of the `ChapterSkipType` is only valid until the next `ChapterAtom` with a `ChapterSkipType` value or the end of the file. ",
      minver: 5,
      crc: false
    },
    0x4598: {
      name: 'ChapterFlagEnabled',
      level: 4,
      type: 'u',
      multiple: false,
      description: 'Set to 1 if the chapter is enabled. It can be enabled/disabled by a Control Track. When disabled, the movie **SHOULD** skip all the content between the TimeStart and TimeEnd of this chapter; see (#chapter-flags) on Chapter flags.',
      mandatory: true,
      range: '0-1',
      minver: 1,
      default: '1',
      crc: false
    },
    0x45a3: {
      name: 'TagName',
      level: 4,
      type: '8',
      multiple: false,
      webm: true,
      description: 'The name of the Tag that is going to be stored.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x45b9: {
      name: 'EditionEntry',
      level: 2,
      type: 'm',
      multiple: true,
      webm: true,
      description: 'Contains all information about a Segment edition.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x45bc: {
      name: 'EditionUID',
      level: 3,
      type: 'u',
      multiple: false,
      description: "A unique ID to identify the edition. It's useful for tagging an edition.",
      range: 'not 0',
      minver: 1,
      crc: false
    },
    0x45bd: {
      name: 'EditionFlagHidden',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'Set to 1 if an edition is hidden. Hidden editions **SHOULD NOT** be available to the user interface (but still to Control Tracks; see (#chapter-flags) on Chapter flags).',
      mandatory: true,
      range: '0-1',
      minver: 1,
      default: '0',
      crc: false
    },
    0x45db: {
      name: 'EditionFlagDefault',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'Set to 1 if the edition **SHOULD** be used as the default one.',
      mandatory: true,
      range: '0-1',
      minver: 1,
      default: '0',
      crc: false
    },
    0x45dd: {
      name: 'EditionFlagOrdered',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'Set to 1 if the chapters can be defined multiple times and the order to play them is enforced; see (#editionflagordered).',
      mandatory: true,
      range: '0-1',
      minver: 1,
      default: '0',
      crc: false
    },
    0x45e4: {
      name: 'EditionLanguageIETF',
      level: 4,
      type: 's',
      multiple: true,
      description: 'One language corresponding to the EditionString, in the [@!BCP47] form; see (#language-codes) on language codes.',
      minver: 5,
      crc: false
    },
    0x465c: {
      name: 'FileData',
      level: 3,
      type: 'b',
      multiple: false,
      description: 'The data of the file.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x4660: {
      name: 'FileMediaType',
      level: 3,
      type: 's',
      multiple: false,
      description: 'Media type of the file following the [@!RFC6838] format.',
      mandatory: true,
      cppname: 'MimeType',
      minver: 1,
      crc: false
    },
    0x4661: {
      name: 'FileUsedStartTime',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'The timestamp at which this optimized font attachment comes into context, expressed in Segment Ticks which is based on TimestampScale. See [@?DivXWorldFonts].',
      minver: 0,
      maxver: 0,
      divx: true,
      crc: false
    },
    0x4662: {
      name: 'FileUsedEndTime',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'The timestamp at which this optimized font attachment goes out of context, expressed in Segment Ticks which is based on TimestampScale. See [@?DivXWorldFonts].',
      minver: 0,
      maxver: 0,
      divx: true,
      crc: false
    },
    0x466e: {
      name: 'FileName',
      level: 3,
      type: '8',
      multiple: false,
      description: 'Filename of the attached file.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x4675: {
      name: 'FileReferral',
      level: 3,
      type: 'b',
      multiple: false,
      description: 'A binary value that a track/codec can refer to when the attachment is needed.',
      minver: 0,
      maxver: 0,
      crc: false
    },
    0x467e: {
      name: 'FileDescription',
      level: 3,
      type: '8',
      multiple: false,
      description: 'A human-friendly name for the attached file.',
      minver: 1,
      crc: false
    },
    0x46ae: {
      name: 'FileUID',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'Unique ID representing the file, as random as possible.',
      mandatory: true,
      range: 'not 0',
      minver: 1,
      crc: false
    },
    0x47e1: {
      name: 'ContentEncAlgo',
      level: 6,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'The encryption algorithm used.',
      mandatory: true,
      minver: 1,
      default: '0',
      crc: false
    },
    0x47e2: {
      name: 'ContentEncKeyID',
      level: 6,
      type: 'b',
      multiple: false,
      webm: true,
      description: 'For public key algorithms this is the ID of the public key the the data was encrypted with.',
      minver: 1,
      crc: false
    },
    0x47e3: {
      name: 'ContentSignature',
      level: 6,
      type: 'b',
      multiple: false,
      description: 'A cryptographic signature of the contents.',
      minver: 1,
      maxver: 0,
      crc: false
    },
    0x47e4: {
      name: 'ContentSigKeyID',
      level: 6,
      type: 'b',
      multiple: false,
      description: 'This is the ID of the private key the data was signed with.',
      minver: 1,
      maxver: 0,
      crc: false
    },
    0x47e5: {
      name: 'ContentSigAlgo',
      level: 6,
      type: 'u',
      multiple: false,
      description: 'The algorithm used for the signature.',
      minver: 1,
      maxver: 0,
      default: '0',
      crc: false
    },
    0x47e6: {
      name: 'ContentSigHashAlgo',
      level: 6,
      type: 'u',
      multiple: false,
      description: 'The hash algorithm used for the signature.',
      minver: 1,
      maxver: 0,
      default: '0',
      crc: false
    },
    0x47e7: {
      name: 'ContentEncAESSettings',
      level: 6,
      type: 'm',
      multiple: true,
      webm: true,
      description: 'Settings describing the encryption algorithm used. If `ContentEncAlgo` != 5 this **MUST** be ignored.',
      minver: 4,
      crc: false
    },
    0x47e8: {
      name: 'AESSettingsCipherMode',
      level: 7,
      type: 'u',
      multiple: true,
      webm: true,
      description: 'The AES cipher mode used in the encryption.',
      mandatory: true,
      minver: 4,
      crc: false
    },
    0x4d80: {
      name: 'MuxingApp',
      level: 2,
      type: '8',
      multiple: false,
      webm: true,
      description: 'Muxing application or library (example: "libmatroska-0.4.3").',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x4dbb: {
      name: 'Seek',
      level: 2,
      type: 'm',
      multiple: true,
      webm: true,
      description: 'Contains a single seek entry to an EBML Element.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x5031: {
      name: 'ContentEncodingOrder',
      level: 5,
      type: 'u',
      multiple: true,
      webm: true,
      description: 'Tells when this modification was used during encoding/muxing starting with 0 and counting upwards. The decoder/demuxer has to start with the highest order number it finds and work its way down. This value has to be unique over all ContentEncodingOrder Elements in the TrackEntry that contains this ContentEncodingOrder element.',
      mandatory: true,
      minver: 1,
      default: '0',
      crc: false
    },
    0x5032: {
      name: 'ContentEncodingScope',
      level: 5,
      type: 'u',
      multiple: false,
      webm: true,
      description: "A bit field that describes which Elements have been modified in this way. Values (big-endian) can be OR'ed.",
      mandatory: true,
      minver: 1,
      default: '1',
      crc: false
    },
    0x5033: {
      name: 'ContentEncodingType',
      level: 5,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'A value describing what kind of transformation is applied.',
      mandatory: true,
      minver: 1,
      default: '0',
      crc: false
    },
    0x5034: {
      name: 'ContentCompression',
      level: 5,
      type: 'm',
      multiple: false,
      description: 'Settings describing the compression used. This Element **MUST** be present if the value of ContentEncodingType is 0 and absent otherwise. Each block **MUST** be decompressable even if no previous block is available in order not to prevent seeking.',
      minver: 1,
      crc: false
    },
    0x5035: {
      name: 'ContentEncryption',
      level: 5,
      type: 'm',
      multiple: false,
      webm: true,
      description: 'Settings describing the encryption used. This Element **MUST** be present if the value of `ContentEncodingType` is 1 (encryption) and **MUST** be ignored otherwise. A Matroska Player **MAY** support encryption.',
      minver: 1,
      crc: false
    },
    0x52f1: {
      name: 'Emphasis',
      level: 4,
      type: 'u',
      multiple: false,
      description: 'Audio emphasis applied on audio samples. The player **MUST** apply the inverse emphasis to get the proper audio samples.',
      mandatory: true,
      minver: 5,
      default: '0',
      crc: false
    },
    0x535f: {
      name: 'CueRefNumber',
      level: 5,
      type: 'u',
      multiple: false,
      description: 'Number of the referenced Block of Track X in the specified Cluster.',
      range: 'not 0',
      minver: 0,
      maxver: 0,
      default: '1',
      crc: false
    },
    0x536e: {
      name: 'Name',
      level: 3,
      type: '8',
      multiple: false,
      webm: true,
      description: 'A human-readable track name.',
      cppname: 'TrackName',
      minver: 1,
      crc: false
    },
    0x5378: {
      name: 'CueBlockNumber',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Number of the Block in the specified Cluster.',
      range: 'not 0',
      minver: 1,
      crc: false
    },
    0x537f: {
      name: 'TrackOffset',
      level: 3,
      type: 'i',
      multiple: false,
      description: "A value to add to the Block's Timestamp, expressed in Matroska Ticks -- i.e., in nanoseconds; see (#timestamp-ticks). This can be used to adjust the playback offset of a track.",
      minver: 0,
      maxver: 0,
      default: '0',
      crc: false
    },
    0x53ab: {
      name: 'SeekID',
      level: 3,
      type: 'b',
      multiple: false,
      webm: true,
      description: 'The binary EBML ID of a Top-Level Element.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x53ac: {
      name: 'SeekPosition',
      level: 3,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'The Segment Position ((#segment-position)) of a Top-Level Element.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x53b8: {
      name: 'StereoMode',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Stereo-3D video mode. There are some more details in (#multi-planar-and-3d-videos).',
      mandatory: true,
      cppname: 'VideoStereoMode',
      minver: 3,
      default: '0',
      crc: false
    },
    0x53b9: {
      name: 'OldStereoMode',
      level: 4,
      type: 'u',
      multiple: false,
      description: 'Bogus StereoMode value used in old versions of libmatroska.',
      minver: 1,
      maxver: 2,
      crc: false
    },
    0x53c0: {
      name: 'AlphaMode',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Indicate whether the BlockAdditional Element with BlockAddID of "1" contains Alpha data, as defined by to the Codec Mapping for the `CodecID`. Undefined values **SHOULD NOT** be used as the behavior of known implementations is different (considered either as 0 or 1).',
      mandatory: true,
      cppname: 'VideoAlphaMode',
      minver: 3,
      default: '0',
      crc: false
    },
    0x54aa: {
      name: 'PixelCropBottom',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'The number of video pixels to remove at the bottom of the image.',
      mandatory: true,
      cppname: 'VideoPixelCropBottom',
      minver: 1,
      default: '0',
      crc: false
    },
    0x54b0: {
      name: 'DisplayWidth',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Width of the video frames to display. Applies to the video frame after cropping (PixelCrop* Elements).',
      range: 'not 0',
      cppname: 'VideoDisplayWidth',
      minver: 1,
      crc: false
    },
    0x54b2: {
      name: 'DisplayUnit',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'How DisplayWidth & DisplayHeight are interpreted.',
      mandatory: true,
      cppname: 'VideoDisplayUnit',
      minver: 1,
      default: '0',
      crc: false
    },
    0x54b3: {
      name: 'AspectRatioType',
      level: 4,
      type: 'u',
      multiple: false,
      description: 'Specify the possible modifications to the aspect ratio.',
      cppname: 'VideoAspectRatio',
      minver: 0,
      maxver: 0,
      default: '0',
      crc: false
    },
    0x54ba: {
      name: 'DisplayHeight',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Height of the video frames to display. Applies to the video frame after cropping (PixelCrop* Elements).',
      range: 'not 0',
      cppname: 'VideoDisplayHeight',
      minver: 1,
      crc: false
    },
    0x54bb: {
      name: 'PixelCropTop',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'The number of video pixels to remove at the top of the image.',
      mandatory: true,
      cppname: 'VideoPixelCropTop',
      minver: 1,
      default: '0',
      crc: false
    },
    0x54cc: {
      name: 'PixelCropLeft',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'The number of video pixels to remove on the left of the image.',
      mandatory: true,
      cppname: 'VideoPixelCropLeft',
      minver: 1,
      default: '0',
      crc: false
    },
    0x54dd: {
      name: 'PixelCropRight',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'The number of video pixels to remove on the right of the image.',
      mandatory: true,
      cppname: 'VideoPixelCropRight',
      minver: 1,
      default: '0',
      crc: false
    },
    0x55aa: {
      name: 'FlagForced',
      level: 3,
      type: 'u',
      multiple: false,
      webm: true,
      description: "Applies only to subtitles. Set if that track is eligible for automatic selection by the player if it matches the user's language preference, even if the user's preferences would normally not enable subtitles with the selected audio track; this can be used for tracks containing only translations of foreign-language audio or onscreen text. See (#default-track-selection) for more details.",
      mandatory: true,
      range: '0-1',
      cppname: 'TrackFlagForced',
      minver: 1,
      default: '0',
      crc: false
    },
    0x55ab: {
      name: 'FlagHearingImpaired',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'Set to 1 if and only if that track is suitable for users with hearing impairments.',
      range: '0-1',
      minver: 4,
      crc: false
    },
    0x55ac: {
      name: 'FlagVisualImpaired',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'Set to 1 if and only if that track is suitable for users with visual impairments.',
      range: '0-1',
      minver: 4,
      crc: false
    },
    0x55ad: {
      name: 'FlagTextDescriptions',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'Set to 1 if and only if that track contains textual descriptions of video content.',
      range: '0-1',
      minver: 4,
      crc: false
    },
    0x55ae: {
      name: 'FlagOriginal',
      level: 3,
      type: 'u',
      multiple: false,
      description: "Set to 1 if and only if that track is in the content's original language.",
      range: '0-1',
      minver: 4,
      crc: false
    },
    0x55af: {
      name: 'FlagCommentary',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'Set to 1 if and only if that track contains commentary.',
      range: '0-1',
      minver: 4,
      crc: false
    },
    0x55b0: {
      name: 'Colour',
      level: 4,
      type: 'm',
      multiple: false,
      webm: true,
      description: 'Settings describing the colour format.',
      cppname: 'VideoColour',
      minver: 4,
      crc: false
    },
    0x55b1: {
      name: 'MatrixCoefficients',
      level: 5,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'The Matrix Coefficients of the video used to derive luma and chroma values from red, green, and blue color primaries. For clarity, the value and meanings for MatrixCoefficients are adopted from Table 4 of ISO/IEC 23001-8:2016 or ITU-T H.273.',
      mandatory: true,
      cppname: 'VideoColourMatrix',
      minver: 4,
      default: '2',
      crc: false
    },
    0x55b2: {
      name: 'BitsPerChannel',
      level: 5,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Number of decoded bits per channel. A value of 0 indicates that the BitsPerChannel is unspecified.',
      mandatory: true,
      cppname: 'VideoBitsPerChannel',
      minver: 4,
      default: '0',
      crc: false
    },
    0x55b3: {
      name: 'ChromaSubsamplingHorz',
      level: 5,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'The amount of pixels to remove in the Cr and Cb channels for every pixel not removed horizontally. Example: For video with 4:2:0 chroma subsampling, the ChromaSubsamplingHorz **SHOULD** be set to 1.',
      cppname: 'VideoChromaSubsampHorz',
      minver: 4,
      crc: false
    },
    0x55b4: {
      name: 'ChromaSubsamplingVert',
      level: 5,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'The amount of pixels to remove in the Cr and Cb channels for every pixel not removed vertically. Example: For video with 4:2:0 chroma subsampling, the ChromaSubsamplingVert **SHOULD** be set to 1.',
      cppname: 'VideoChromaSubsampVert',
      minver: 4,
      crc: false
    },
    0x55b5: {
      name: 'CbSubsamplingHorz',
      level: 5,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'The amount of pixels to remove in the Cb channel for every pixel not removed horizontally. This is additive with ChromaSubsamplingHorz. Example: For video with 4:2:1 chroma subsampling, the ChromaSubsamplingHorz **SHOULD** be set to 1 and CbSubsamplingHorz **SHOULD** be set to 1.',
      cppname: 'VideoCbSubsampHorz',
      minver: 4,
      crc: false
    },
    0x55b6: {
      name: 'CbSubsamplingVert',
      level: 5,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'The amount of pixels to remove in the Cb channel for every pixel not removed vertically. This is additive with ChromaSubsamplingVert.',
      cppname: 'VideoCbSubsampVert',
      minver: 4,
      crc: false
    },
    0x55b7: {
      name: 'ChromaSitingHorz',
      level: 5,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'How chroma is subsampled horizontally.',
      mandatory: true,
      cppname: 'VideoChromaSitHorz',
      minver: 4,
      default: '0',
      crc: false
    },
    0x55b8: {
      name: 'ChromaSitingVert',
      level: 5,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'How chroma is subsampled vertically.',
      mandatory: true,
      cppname: 'VideoChromaSitVert',
      minver: 4,
      default: '0',
      crc: false
    },
    0x55b9: {
      name: 'Range',
      level: 5,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Clipping of the color ranges.',
      mandatory: true,
      cppname: 'VideoColourRange',
      minver: 4,
      default: '0',
      crc: false
    },
    0x55ba: {
      name: 'TransferCharacteristics',
      level: 5,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'The transfer characteristics of the video. For clarity, the value and meanings for TransferCharacteristics are adopted from Table 3 of ISO/IEC 23091-4 or ITU-T H.273.',
      mandatory: true,
      cppname: 'VideoColourTransferCharacter',
      minver: 4,
      default: '2',
      crc: false
    },
    0x55bb: {
      name: 'Primaries',
      level: 5,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'The colour primaries of the video. For clarity, the value and meanings for Primaries are adopted from Table 2 of ISO/IEC 23091-4 or ITU-T H.273.',
      mandatory: true,
      cppname: 'VideoColourPrimaries',
      minver: 4,
      default: '2',
      crc: false
    },
    0x55bc: {
      name: 'MaxCLL',
      level: 5,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Maximum brightness of a single pixel (Maximum Content Light Level) in candelas per square meter (cd/m^2^).',
      cppname: 'VideoColourMaxCLL',
      minver: 4,
      crc: false
    },
    0x55bd: {
      name: 'MaxFALL',
      level: 5,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Maximum brightness of a single full frame (Maximum Frame-Average Light Level) in candelas per square meter (cd/m^2^).',
      cppname: 'VideoColourMaxFALL',
      minver: 4,
      crc: false
    },
    0x55d0: {
      name: 'MasteringMetadata',
      level: 5,
      type: 'm',
      multiple: false,
      webm: true,
      description: 'SMPTE 2086 mastering data.',
      cppname: 'VideoColourMasterMeta',
      minver: 4,
      crc: false
    },
    0x55d1: {
      name: 'PrimaryRChromaticityX',
      level: 6,
      type: 'f',
      multiple: false,
      webm: true,
      description: 'Red X chromaticity coordinate, as defined by [@!CIE-1931].',
      range: '0x0p+0-0x1p+0',
      cppname: 'VideoRChromaX',
      minver: 4,
      crc: false
    },
    0x55d2: {
      name: 'PrimaryRChromaticityY',
      level: 6,
      type: 'f',
      multiple: false,
      webm: true,
      description: 'Red Y chromaticity coordinate, as defined by [@!CIE-1931].',
      range: '0x0p+0-0x1p+0',
      cppname: 'VideoRChromaY',
      minver: 4,
      crc: false
    },
    0x55d3: {
      name: 'PrimaryGChromaticityX',
      level: 6,
      type: 'f',
      multiple: false,
      webm: true,
      description: 'Green X chromaticity coordinate, as defined by [@!CIE-1931].',
      range: '0x0p+0-0x1p+0',
      cppname: 'VideoGChromaX',
      minver: 4,
      crc: false
    },
    0x55d4: {
      name: 'PrimaryGChromaticityY',
      level: 6,
      type: 'f',
      multiple: false,
      webm: true,
      description: 'Green Y chromaticity coordinate, as defined by [@!CIE-1931].',
      range: '0x0p+0-0x1p+0',
      cppname: 'VideoGChromaY',
      minver: 4,
      crc: false
    },
    0x55d5: {
      name: 'PrimaryBChromaticityX',
      level: 6,
      type: 'f',
      multiple: false,
      webm: true,
      description: 'Blue X chromaticity coordinate, as defined by [@!CIE-1931].',
      range: '0x0p+0-0x1p+0',
      cppname: 'VideoBChromaX',
      minver: 4,
      crc: false
    },
    0x55d6: {
      name: 'PrimaryBChromaticityY',
      level: 6,
      type: 'f',
      multiple: false,
      webm: true,
      description: 'Blue Y chromaticity coordinate, as defined by [@!CIE-1931].',
      range: '0x0p+0-0x1p+0',
      cppname: 'VideoBChromaY',
      minver: 4,
      crc: false
    },
    0x55d7: {
      name: 'WhitePointChromaticityX',
      level: 6,
      type: 'f',
      multiple: false,
      webm: true,
      description: 'White X chromaticity coordinate, as defined by [@!CIE-1931].',
      range: '0x0p+0-0x1p+0',
      cppname: 'VideoWhitePointChromaX',
      minver: 4,
      crc: false
    },
    0x55d8: {
      name: 'WhitePointChromaticityY',
      level: 6,
      type: 'f',
      multiple: false,
      webm: true,
      description: 'White Y chromaticity coordinate, as defined by [@!CIE-1931].',
      range: '0x0p+0-0x1p+0',
      cppname: 'VideoWhitePointChromaY',
      minver: 4,
      crc: false
    },
    0x55d9: {
      name: 'LuminanceMax',
      level: 6,
      type: 'f',
      multiple: false,
      webm: true,
      description: 'Maximum luminance. Represented in candelas per square meter (cd/m^2^).',
      range: '>= 0x0p+0',
      cppname: 'VideoLuminanceMax',
      minver: 4,
      crc: false
    },
    0x55da: {
      name: 'LuminanceMin',
      level: 6,
      type: 'f',
      multiple: false,
      webm: true,
      description: 'Minimum luminance. Represented in candelas per square meter (cd/m^2^).',
      range: '>= 0x0p+0',
      cppname: 'VideoLuminanceMin',
      minver: 4,
      crc: false
    },
    0x55ee: {
      name: 'MaxBlockAdditionID',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'The maximum value of BlockAddID ((#blockaddid-element)). A value 0 means there is no BlockAdditions ((#blockadditions-element)) for this track.',
      mandatory: true,
      minver: 1,
      default: '0',
      crc: false
    },
    0x5654: {
      name: 'ChapterStringUID',
      level: 4,
      type: '8',
      multiple: false,
      webm: true,
      description: 'A unique string ID to identify the Chapter. For example it is used as the storage for [@?WebVTT] cue identifier values.',
      minver: 3,
      crc: false
    },
    0x56aa: {
      name: 'CodecDelay',
      level: 3,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'CodecDelay is The codec-built-in delay, expressed in Matroska Ticks -- i.e., in nanoseconds; see (#timestamp-ticks). It represents the amount of codec samples that will be discarded by the decoder during playback. This timestamp value **MUST** be subtracted from each frame timestamp in order to get the timestamp that will be actually played. The value **SHOULD** be small so the muxing of tracks with the same actual timestamp are in the same Cluster.',
      mandatory: true,
      minver: 4,
      default: '0',
      crc: false
    },
    0x56bb: {
      name: 'SeekPreRoll',
      level: 3,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'After a discontinuity, SeekPreRoll is the duration of the data the decoder **MUST** decode before the decoded data is valid, expressed in Matroska Ticks -- i.e., in nanoseconds; see (#timestamp-ticks).',
      mandatory: true,
      minver: 4,
      default: '0',
      crc: false
    },
    0x5741: {
      name: 'WritingApp',
      level: 2,
      type: '8',
      multiple: false,
      webm: true,
      description: 'Writing application (example: "mkvmerge-0.3.3").',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x5854: {
      name: 'SilentTracks',
      level: 2,
      type: 'm',
      multiple: false,
      description: 'The list of tracks that are not used in that part of the stream. It is useful when using overlay tracks on seeking or to decide what track to use.',
      cppname: 'ClusterSilentTracks',
      minver: 0,
      maxver: 0,
      crc: false
    },
    0x58d7: {
      name: 'SilentTrackNumber',
      level: 3,
      type: 'u',
      multiple: true,
      description: 'One of the track number that are not used from now on in the stream. It could change later if not specified as silent in a further Cluster.',
      cppname: 'ClusterSilentTrackNumber',
      minver: 0,
      maxver: 0,
      crc: false
    },
    0x61a7: {
      name: 'AttachedFile',
      level: 2,
      type: 'm',
      multiple: true,
      description: 'An attached file.',
      mandatory: true,
      cppname: 'Attached',
      minver: 1,
      crc: false
    },
    0x6240: {
      name: 'ContentEncoding',
      level: 4,
      type: 'm',
      multiple: true,
      webm: true,
      description: 'Settings for one content encoding like compression or encryption.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x6264: {
      name: 'BitDepth',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Bits per sample, mostly used for PCM.',
      range: 'not 0',
      cppname: 'AudioBitDepth',
      minver: 1,
      crc: false
    },
    0x63a2: {
      name: 'CodecPrivate',
      level: 3,
      type: 'b',
      multiple: false,
      webm: true,
      description: 'Private data only known to the codec.',
      minver: 1,
      crc: false
    },
    0x63c0: {
      name: 'Targets',
      level: 3,
      type: 'm',
      multiple: false,
      webm: true,
      description: 'Specifies which other elements the metadata represented by the Tag applies to. If empty or omitted, then the Tag describes everything in the Segment.',
      mandatory: true,
      cppname: 'TagTargets',
      minver: 1,
      crc: false
    },
    0x63c3: {
      name: 'ChapterPhysicalEquiv',
      level: 4,
      type: 'u',
      multiple: false,
      description: 'Specify the physical equivalent of this ChapterAtom like "DVD" (60) or "SIDE" (50); see (#physical-types) for a complete list of values.',
      minver: 1,
      crc: false
    },
    0x63c4: {
      name: 'TagChapterUID',
      level: 4,
      type: 'u',
      multiple: true,
      description: 'A unique ID to identify the Chapter(s) the tags belong to.',
      minver: 1,
      default: '0',
      crc: false
    },
    0x63c5: {
      name: 'TagTrackUID',
      level: 4,
      type: 'u',
      multiple: true,
      webm: true,
      description: 'A unique ID to identify the Track(s) the tags belong to.',
      minver: 1,
      default: '0',
      crc: false
    },
    0x63c6: {
      name: 'TagAttachmentUID',
      level: 4,
      type: 'u',
      multiple: true,
      description: 'A unique ID to identify the Attachment(s) the tags belong to.',
      minver: 1,
      default: '0',
      crc: false
    },
    0x63c9: {
      name: 'TagEditionUID',
      level: 4,
      type: 'u',
      multiple: true,
      description: 'A unique ID to identify the EditionEntry(s) the tags belong to.',
      minver: 1,
      default: '0',
      crc: false
    },
    0x63ca: {
      name: 'TargetType',
      level: 4,
      type: 's',
      multiple: false,
      webm: true,
      description: 'An informational string that can be used to display the logical level of the target like "ALBUM", "TRACK", "MOVIE", "CHAPTER", etc. ; see Section 6.4 of [@?MatroskaTags].',
      cppname: 'TagTargetType',
      minver: 1,
      crc: false
    },
    0x6532: {
      name: 'SignedElement',
      level: 2,
      type: 'b',
      multiple: true,
      webm: false,
      description: 'An element ID whose data will be used to compute the signature.',
      minver: 1,
      crc: false
    },
    0x6624: {
      name: 'TrackTranslate',
      level: 3,
      type: 'm',
      multiple: true,
      description: 'The mapping between this `TrackEntry` and a track value in the given Chapter Codec.',
      minver: 1,
      crc: false
    },
    0x66a5: {
      name: 'TrackTranslateTrackID',
      level: 4,
      type: 'b',
      multiple: false,
      description: 'The binary value used to represent this `TrackEntry` in the chapter codec data. The format depends on the `ChapProcessCodecID` used; see (#chapprocesscodecid-element).',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x66bf: {
      name: 'TrackTranslateCodec',
      level: 4,
      type: 'u',
      multiple: false,
      description: 'This `TrackTranslate` applies to this chapter codec of the given chapter edition(s); see (#chapprocesscodecid-element).',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x66fc: {
      name: 'TrackTranslateEditionUID',
      level: 4,
      type: 'u',
      multiple: true,
      description: 'Specify a chapter edition UID on which this `TrackTranslate` applies.',
      minver: 1,
      crc: false
    },
    0x67c8: {
      name: 'SimpleTag',
      level: 3,
      type: 'm',
      multiple: true,
      webm: true,
      description: 'Contains general information about the target.',
      mandatory: true,
      cppname: 'TagSimple',
      minver: 1,
      crc: false
    },
    0x68ca: {
      name: 'TargetTypeValue',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'A number to indicate the logical level of the target.',
      mandatory: true,
      cppname: 'TagTargetTypeValue',
      minver: 1,
      default: '50',
      crc: false
    },
    0x6911: {
      name: 'ChapProcessCommand',
      level: 5,
      type: 'm',
      multiple: true,
      description: 'Contains all the commands associated to the Atom.',
      cppname: 'ChapterProcessCommand',
      minver: 1,
      crc: false
    },
    0x6922: {
      name: 'ChapProcessTime',
      level: 6,
      type: 'u',
      multiple: false,
      description: 'Defines when the process command **SHOULD** be handled',
      mandatory: true,
      cppname: 'ChapterProcessTime',
      minver: 1,
      crc: false
    },
    0x6924: {
      name: 'ChapterTranslate',
      level: 2,
      type: 'm',
      multiple: true,
      description: 'The mapping between this `Segment` and a segment value in the given Chapter Codec.',
      minver: 1,
      crc: false
    },
    0x6933: {
      name: 'ChapProcessData',
      level: 6,
      type: 'b',
      multiple: false,
      description: 'Contains the command information. The data **SHOULD** be interpreted depending on the ChapProcessCodecID value. For ChapProcessCodecID = 1, the data correspond to the binary DVD cell pre/post commands; see (#menu-features) on DVD menus.',
      mandatory: true,
      cppname: 'ChapterProcessData',
      minver: 1,
      crc: false
    },
    0x6944: {
      name: 'ChapProcess',
      level: 4,
      type: 'm',
      multiple: true,
      description: 'Contains all the commands associated to the Atom.',
      cppname: 'ChapterProcess',
      minver: 1,
      crc: false
    },
    0x6955: {
      name: 'ChapProcessCodecID',
      level: 5,
      type: 'u',
      multiple: false,
      description: 'Contains the type of the codec used for the processing. A value of 0 means native Matroska processing (to be defined), a value of 1 means the DVD command set is used; see (#menu-features) on DVD menus. More codec IDs can be added later.',
      mandatory: true,
      cppname: 'ChapterProcessCodecID',
      minver: 1,
      default: '0',
      crc: false
    },
    0x69a5: {
      name: 'ChapterTranslateID',
      level: 3,
      type: 'b',
      multiple: false,
      description: 'The binary value used to represent this Segment in the chapter codec data. The format depends on the ChapProcessCodecID used; see (#chapprocesscodecid-element).',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x69bf: {
      name: 'ChapterTranslateCodec',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'This `ChapterTranslate` applies to this chapter codec of the given chapter edition(s); see (#chapprocesscodecid-element).',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x69fc: {
      name: 'ChapterTranslateEditionUID',
      level: 3,
      type: 'u',
      multiple: true,
      description: 'Specify a chapter edition UID on which this `ChapterTranslate` applies.',
      minver: 1,
      crc: false
    },
    0x6d80: {
      name: 'ContentEncodings',
      level: 3,
      type: 'm',
      multiple: false,
      webm: true,
      description: 'Settings for several content encoding mechanisms like compression or encryption.',
      minver: 1,
      crc: false
    },
    0x6de7: {
      name: 'MinCache',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'The minimum number of frames a player should be able to cache during playback. If set to 0, the reference pseudo-cache system is not used.',
      mandatory: true,
      cppname: 'TrackMinCache',
      minver: 0,
      maxver: 0,
      default: '0',
      crc: false
    },
    0x6df8: {
      name: 'MaxCache',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'The maximum cache size necessary to store referenced frames in and the current frame. 0 means no cache is needed.',
      cppname: 'TrackMaxCache',
      minver: 0,
      maxver: 0,
      crc: false
    },
    0x6e67: {
      name: 'ChapterSegmentUUID',
      level: 4,
      type: 'b',
      multiple: false,
      description: 'The SegmentUUID of another Segment to play during this chapter.',
      cppname: 'ChapterSegmentUID',
      minver: 1,
      crc: false
    },
    0x6ebc: {
      name: 'ChapterSegmentEditionUID',
      level: 4,
      type: 'u',
      multiple: false,
      description: 'The EditionUID to play from the Segment linked in ChapterSegmentUUID. If ChapterSegmentEditionUID is undeclared, then no Edition of the linked Segment is used; see (#medium-linking) on medium-linking Segments.',
      range: 'not 0',
      minver: 1,
      crc: false
    },
    0x6fab: {
      name: 'TrackOverlay',
      level: 3,
      type: 'u',
      multiple: true,
      description: 'Specify that this track is an overlay track for the Track specified (in the u-integer). That means when this track has a gap on SilentTracks, the overlay track should be used instead. The order of multiple TrackOverlay matters, the first one is the one that should be used. If not found it should be the second, etc.',
      minver: 1,
      maxver: 0,
      crc: false
    },
    0x7373: {
      name: 'Tag',
      level: 2,
      type: 'm',
      multiple: true,
      webm: true,
      description: 'A single metadata descriptor.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x7384: {
      name: 'SegmentFilename',
      level: 2,
      type: '8',
      multiple: false,
      description: 'A filename corresponding to this Segment.',
      minver: 1,
      crc: false
    },
    0x73a4: {
      name: 'SegmentUUID',
      level: 2,
      type: 'b',
      multiple: false,
      description: 'A randomly generated unique ID to identify the Segment amongst many others (128 bits). It is equivalent to a UUID v4 [@!RFC4122] with all bits randomly (or pseudo-randomly) chosen.  An actual UUID v4 value, where some bits are not random, **MAY** also be used.',
      cppname: 'SegmentUID',
      minver: 1,
      crc: false
    },
    0x73c4: {
      name: 'ChapterUID',
      level: 4,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'A unique ID to identify the Chapter.',
      mandatory: true,
      range: 'not 0',
      minver: 1,
      crc: false
    },
    0x73c5: {
      name: 'TrackUID',
      level: 3,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'A unique ID to identify the Track.',
      mandatory: true,
      range: 'not 0',
      minver: 1,
      crc: false
    },
    0x7446: {
      name: 'AttachmentLink',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'The UID of an attachment that is used by this codec.',
      range: 'not 0',
      cppname: 'TrackAttachmentLink',
      minver: 1,
      maxver: 3,
      crc: false
    },
    0x75a1: {
      name: 'BlockAdditions',
      level: 3,
      type: 'm',
      multiple: false,
      webm: true,
      description: 'Contain additional binary data to complete the main one; see Codec BlockAdditions section of [@?MatroskaCodec] for more information. An EBML parser that has no knowledge of the Block structure could still see and use/skip these data.',
      minver: 1,
      crc: false
    },
    0x75a2: {
      name: 'DiscardPadding',
      level: 3,
      type: 'i',
      multiple: false,
      webm: true,
      description: 'Duration of the silent data added to the Block, expressed in Matroska Ticks -- i.e., in nanoseconds; see (#timestamp-ticks) (padding at the end of the Block for positive value, at the beginning of the Block for negative value). The duration of DiscardPadding is not calculated in the duration of the TrackEntry and **SHOULD** be discarded during playback.',
      minver: 4,
      crc: false
    },
    0x7670: {
      name: 'Projection',
      level: 4,
      type: 'm',
      multiple: false,
      webm: true,
      description: 'Describes the video projection details. Used to render spherical, VR videos or flipping videos horizontally/vertically.',
      cppname: 'VideoProjection',
      minver: 4,
      crc: false
    },
    0x7671: {
      name: 'ProjectionType',
      level: 5,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Describes the projection used for this video track.',
      mandatory: true,
      cppname: 'VideoProjectionType',
      minver: 4,
      default: '0',
      crc: false
    },
    0x7672: {
      name: 'ProjectionPrivate',
      level: 5,
      type: 'b',
      multiple: false,
      webm: true,
      description: "Private data that only applies to a specific projection.  *  If `ProjectionType` equals 0 (Rectangular), then this element **MUST NOT** be present. *  If `ProjectionType` equals 1 (Equirectangular), then this element **MUST** be present and contain the same binary data that would be stored inside an ISOBMFF Equirectangular Projection Box ('equi'). *  If `ProjectionType` equals 2 (Cubemap), then this element **MUST** be present and contain the same binary data that would be stored inside an ISOBMFF Cubemap Projection Box ('cbmp'). *  If `ProjectionType` equals 3 (Mesh), then this element **MUST** be present and contain the same binary data that would be stored inside an ISOBMFF Mesh Projection Box ('mshp').",
      cppname: 'VideoProjectionPrivate',
      minver: 4,
      crc: false
    },
    0x7673: {
      name: 'ProjectionPoseYaw',
      level: 5,
      type: 'f',
      multiple: false,
      webm: true,
      description: 'Specifies a yaw rotation to the projection.  Value represents a clockwise rotation, in degrees, around the up vector. This rotation must be applied before any `ProjectionPosePitch` or `ProjectionPoseRoll` rotations. The value of this element **MUST** be in the -180 to 180 degree range, both included.  Setting `ProjectionPoseYaw` to 180 or -180 degrees, with the `ProjectionPoseRoll` and `ProjectionPosePitch` set to 0 degrees flips the image horizontally.',
      mandatory: true,
      range: '>= -0xB4p+0, <= 0xB4p+0',
      cppname: 'VideoProjectionPoseYaw',
      minver: 4,
      default: '0x0p+0',
      crc: false
    },
    0x7674: {
      name: 'ProjectionPosePitch',
      level: 5,
      type: 'f',
      multiple: false,
      webm: true,
      description: 'Specifies a pitch rotation to the projection.  Value represents a counter-clockwise rotation, in degrees, around the right vector. This rotation must be applied after the `ProjectionPoseYaw` rotation and before the `ProjectionPoseRoll` rotation. The value of this element **MUST** be in the -90 to 90 degree range, both included.',
      mandatory: true,
      range: '>= -0x5Ap+0, <= 0x5Ap+0',
      cppname: 'VideoProjectionPosePitch',
      minver: 4,
      default: '0x0p+0',
      crc: false
    },
    0x7675: {
      name: 'ProjectionPoseRoll',
      level: 5,
      type: 'f',
      multiple: false,
      webm: true,
      description: 'Specifies a roll rotation to the projection.  Value represents a counter-clockwise rotation, in degrees, around the forward vector. This rotation must be applied after the `ProjectionPoseYaw` and `ProjectionPosePitch` rotations. The value of this element **MUST** be in the -180 to 180 degree range, both included.  Setting `ProjectionPoseRoll` to 180 or -180 degrees, the `ProjectionPoseYaw` to 180 or -180 degrees with `ProjectionPosePitch` set to 0 degrees flips the image vertically.  Setting `ProjectionPoseRoll` to 180 or -180 degrees, with the `ProjectionPoseYaw` and `ProjectionPosePitch` set to 0 degrees flips the image horizontally and vertically.',
      mandatory: true,
      range: '>= -0xB4p+0, <= 0xB4p+0',
      cppname: 'VideoProjectionPoseRoll',
      minver: 4,
      default: '0x0p+0',
      crc: false
    },
    0x78b5: {
      name: 'OutputSamplingFrequency',
      level: 4,
      type: 'f',
      multiple: false,
      webm: true,
      description: 'Real output sampling frequency in Hz (used for SBR techniques).',
      range: '> 0x0p+0',
      cppname: 'AudioOutputSamplingFreq',
      minver: 1,
      crc: false
    },
    0x7ba9: {
      name: 'Title',
      level: 2,
      type: '8',
      multiple: false,
      webm: true,
      description: 'General name of the Segment.',
      minver: 1,
      crc: false
    },
    0x7d7b: {
      name: 'ChannelPositions',
      level: 4,
      type: 'b',
      multiple: false,
      description: 'Table of horizontal angles for each successive channel.',
      cppname: 'AudioPosition',
      minver: 0,
      maxver: 0,
      crc: false
    },
    0x7e5b: {
      name: 'SignatureElements',
      level: 1,
      type: 'm',
      multiple: true,
      webm: false,
      description: 'Contains elements that will be used to compute the signature.',
      minver: 1,
      crc: false
    },
    0x7e7b: {
      name: 'SignatureElementList',
      level: 2,
      type: 'm',
      multiple: true,
      webm: false,
      description: 'A list consists of a number of consecutive elements that represent one case where data is used in signature. Ex:  means that the BlockAdditional of all Blocks in all Clusters is used for encryption.',
      minver: 1,
      crc: false,
      i: 'Cluster|Block|BlockAdditional'
    },
    0x7e8a: {
      name: 'SignatureAlgo',
      level: 2,
      type: 'u',
      multiple: true,
      webm: false,
      description: 'Signature algorithm used (1=RSA, 2=elliptic).',
      minver: 1,
      crc: false
    },
    0x7e9a: {
      name: 'SignatureHash',
      level: 2,
      type: 'u',
      multiple: true,
      webm: false,
      description: 'Hash algorithm used (1=SHA1-160, 2=MD5).',
      minver: 1,
      crc: false
    },
    0x7ea5: {
      name: 'SignaturePublicKey',
      level: 2,
      type: 'b',
      multiple: true,
      webm: false,
      description: 'The public key to use with the algorithm (in the case of a PKI-based signature).',
      minver: 1,
      crc: false
    },
    0x7eb5: {
      name: 'Signature',
      level: 2,
      type: 'b',
      multiple: true,
      webm: false,
      description: 'The signature of the data (until a new.',
      minver: 1,
      crc: false
    },
    0x22b59c: {
      name: 'Language',
      level: 3,
      type: 's',
      multiple: false,
      webm: true,
      description: 'The language of the track, in the Matroska languages form; see (#language-codes) on language codes. This Element **MUST** be ignored if the LanguageBCP47 Element is used in the same TrackEntry.',
      mandatory: true,
      cppname: 'TrackLanguage',
      minver: 1,
      default: 'eng',
      crc: false
    },
    0x22b59d: {
      name: 'LanguageBCP47',
      level: 3,
      type: 's',
      multiple: false,
      description: 'The language of the track, in the [@!BCP47] form; see (#language-codes) on language codes. If this Element is used, then any Language Elements used in the same TrackEntry **MUST** be ignored.',
      cppname: 'LanguageIETF',
      minver: 4,
      crc: false
    },
    0x23314f: {
      name: 'TrackTimestampScale',
      level: 3,
      type: 'f',
      multiple: false,
      description: 'The scale to apply on this track to work at normal speed in relation with other tracks (mostly used to adjust video speed when the audio length differs).',
      mandatory: true,
      range: '> 0x0p+0',
      cppname: 'TrackTimecodeScale',
      minver: 1,
      maxver: 3,
      default: '0x1p+0',
      crc: false
    },
    0x234e7a: {
      name: 'DefaultDecodedFieldDuration',
      level: 3,
      type: 'u',
      multiple: false,
      description: 'The period between two successive fields at the output of the decoding process, expressed in Matroska Ticks -- i.e., in nanoseconds; see (#timestamp-ticks). see (#defaultdecodedfieldduration) for more information',
      range: 'not 0',
      cppname: 'TrackDefaultDecodedFieldDuration',
      minver: 4,
      crc: false
    },
    0x2383e3: {
      name: 'FrameRate',
      level: 4,
      type: 'f',
      multiple: false,
      description: 'Number of frames per second. This value is Informational only. It is intended for constant frame rate streams, and should not be used for a variable frame rate TrackEntry.',
      range: '> 0x0p+0',
      cppname: 'VideoFrameRate',
      minver: 0,
      maxver: 0,
      crc: false
    },
    0x23e383: {
      name: 'DefaultDuration',
      level: 3,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Number of nanoseconds per frame, expressed in Matroska Ticks -- i.e., in nanoseconds; see (#timestamp-ticks) (frame in the Matroska sense -- one Element put into a (Simple)Block).',
      range: 'not 0',
      cppname: 'TrackDefaultDuration',
      minver: 1,
      crc: false
    },
    0x258688: {
      name: 'CodecName',
      level: 3,
      type: '8',
      multiple: false,
      webm: true,
      description: 'A human-readable string specifying the codec.',
      minver: 1,
      crc: false
    },
    0x26b240: {
      name: 'CodecDownloadURL',
      level: 3,
      type: 's',
      multiple: true,
      description: 'A URL to download about the codec used.',
      minver: 0,
      maxver: 0,
      crc: false
    },
    0x2ad7b1: {
      name: 'TimestampScale',
      level: 2,
      type: 'u',
      multiple: false,
      webm: true,
      description: 'Base unit for Segment Ticks and Track Ticks, in nanoseconds. A TimestampScale value of 1000000 means scaled timestamps in the Segment are expressed in milliseconds; see (#timestamps) on how to interpret timestamps.',
      mandatory: true,
      range: 'not 0',
      cppname: 'TimecodeScale',
      minver: 1,
      default: '1000000',
      crc: false
    },
    0x2ad7b2: {
      name: 'TimecodeScaleDenominator',
      level: 2,
      type: 'u',
      multiple: false,
      description: 'Timestamp scale numerator, see TimecodeScale.',
      mandatory: true,
      minver: 4,
      default: '1000000000',
      crc: false
    },
    0x2eb524: {
      name: 'UncompressedFourCC',
      level: 4,
      type: 'b',
      multiple: false,
      description: "Specify the uncompressed pixel format used for the Track's data as a FourCC. This value is similar in scope to the biCompression value of AVI's `BITMAPINFO` [@?AVIFormat]. There is no definitive list of FourCC values, nor an official registry. Some common values for YUV pixel formats can be found at [@?MSYUV8], [@?MSYUV16] and [@?FourCC-YUV]. Some common values for uncompressed RGB pixel formats can be found at [@?MSRGB] and [@?FourCC-RGB].",
      cppname: 'VideoColourSpace',
      minver: 1,
      crc: false
    },
    0x2fb523: {
      name: 'GammaValue',
      level: 4,
      type: 'f',
      multiple: false,
      description: 'Gamma Value.',
      range: '> 0x0p+0',
      cppname: 'VideoGamma',
      minver: 0,
      maxver: 0,
      crc: false
    },
    0x3a9697: {
      name: 'CodecSettings',
      level: 3,
      type: '8',
      multiple: false,
      description: 'A string describing the encoding setting used.',
      minver: 0,
      maxver: 0,
      crc: false
    },
    0x3b4040: {
      name: 'CodecInfoURL',
      level: 3,
      type: 's',
      multiple: true,
      description: 'A URL to find information about the codec used.',
      minver: 0,
      maxver: 0,
      crc: false
    },
    0x3c83ab: {
      name: 'PrevFilename',
      level: 2,
      type: '8',
      multiple: false,
      description: 'A filename corresponding to the file of the previous Linked Segment.',
      minver: 1,
      crc: false
    },
    0x3cb923: {
      name: 'PrevUUID',
      level: 2,
      type: 'b',
      multiple: false,
      description: 'An ID to identify the previous Segment of a Linked Segment.',
      cppname: 'PrevUID',
      minver: 1,
      crc: false
    },
    0x3e83bb: {
      name: 'NextFilename',
      level: 2,
      type: '8',
      multiple: false,
      description: 'A filename corresponding to the file of the next Linked Segment.',
      minver: 1,
      crc: false
    },
    0x3eb923: {
      name: 'NextUUID',
      level: 2,
      type: 'b',
      multiple: false,
      description: 'An ID to identify the next Segment of a Linked Segment.',
      cppname: 'NextUID',
      minver: 1,
      crc: false
    },
    0x1043a770: {
      name: 'Chapters',
      level: 1,
      type: 'm',
      multiple: false,
      webm: true,
      description: 'A system to define basic menus and partition data. For more detailed information, look at the Chapters explanation in (#chapters).',
      minver: 1,
      crc: false
    },
    0x114d9b74: {
      name: 'SeekHead',
      level: 1,
      type: 'm',
      multiple: true,
      webm: true,
      description: 'Contains seeking information of Top-Level Elements; see (#data-layout).',
      minver: 1,
      crc: false
    },
    0x1254c367: {
      name: 'Tags',
      level: 1,
      type: 'm',
      multiple: true,
      webm: true,
      description: 'Element containing metadata describing Tracks, Editions, Chapters, Attachments, or the Segment as a whole. A list of valid tags can be found in [@?MatroskaTags].',
      minver: 1,
      crc: false
    },
    0x1549a966: {
      name: 'Info',
      level: 1,
      type: 'm',
      multiple: false,
      webm: true,
      description: 'Contains general information about the Segment.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x1654ae6b: {
      name: 'Tracks',
      level: 1,
      type: 'm',
      multiple: false,
      webm: true,
      description: 'A Top-Level Element of information with many tracks described.',
      minver: 1,
      crc: false
    },
    0x18538067: {
      name: 'Segment',
      level: 0,
      type: 'm',
      multiple: false,
      description: 'The Root Element that contains all other Top-Level Elements; see (#data-layout).',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x1941a469: {
      name: 'Attachments',
      level: 1,
      type: 'm',
      multiple: false,
      description: 'Contain attached files.',
      minver: 1,
      crc: false
    },
    0x1a45dfa3: {
      name: 'EBML',
      level: 0,
      type: 'm',
      multiple: false,
      description: 'Set the EBML characteristics of the data to follow. Each EBML document has to start with this.',
      mandatory: true,
      minver: 1,
      crc: false
    },
    0x1b538667: {
      name: 'SignatureSlot',
      level: 1,
      type: 'm',
      multiple: true,
      webm: false,
      description: 'Contain signature of some (coming) elements in the stream.',
      minver: 1,
      crc: false
    },
    0x1c53bb6b: {
      name: 'Cues',
      level: 1,
      type: 'm',
      multiple: false,
      webm: true,
      description: 'A Top-Level Element to speed seeking access. All entries are local to the Segment.',
      minver: 1,
      crc: false
    },
    0x1f43b675: {
      name: 'Cluster',
      level: 1,
      type: 'm',
      multiple: true,
      webm: true,
      description: 'The Top-Level Element containing the (monolithic) Block structure.',
      minver: 1,
      crc: false
    },
  },
  byName: {
    EBMLMaxIDLength: 0x42f2,
    EBMLMaxSizeLength: 0x42f3,
    Segment: 0x18538067,
    SeekHead: 0x114d9b74,
    Seek: 0x4dbb,
    SeekID: 0x53ab,
    SeekPosition: 0x53ac,
    Info: 0x1549a966,
    SegmentUUID: 0x73a4,
    SegmentFilename: 0x7384,
    PrevUUID: 0x3cb923,
    PrevFilename: 0x3c83ab,
    NextUUID: 0x3eb923,
    NextFilename: 0x3e83bb,
    SegmentFamily: 0x4444,
    ChapterTranslate: 0x6924,
    ChapterTranslateID: 0x69a5,
    ChapterTranslateCodec: 0x69bf,
    ChapterTranslateEditionUID: 0x69fc,
    TimestampScale: 0x2ad7b1,
    Duration: 0x4489,
    DateUTC: 0x4461,
    Title: 0x7ba9,
    MuxingApp: 0x4d80,
    WritingApp: 0x5741,
    Cluster: 0x1f43b675,
    Timestamp: 0xe7,
    SilentTracks: 0x5854,
    SilentTrackNumber: 0x58d7,
    Position: 0xa7,
    PrevSize: 0xab,
    SimpleBlock: 0xa3,
    BlockGroup: 0xa0,
    Block: 0xa1,
    BlockVirtual: 0xa2,
    BlockAdditions: 0x75a1,
    BlockMore: 0xa6,
    BlockAdditional: 0xa5,
    BlockAddID: 0xee,
    BlockDuration: 0x9b,
    ReferencePriority: 0xfa,
    ReferenceBlock: 0xfb,
    ReferenceVirtual: 0xfd,
    CodecState: 0xa4,
    DiscardPadding: 0x75a2,
    Slices: 0x8e,
    TimeSlice: 0xe8,
    LaceNumber: 0xcc,
    FrameNumber: 0xcd,
    BlockAdditionID: 0xcb,
    Delay: 0xce,
    SliceDuration: 0xcf,
    ReferenceFrame: 0xc8,
    ReferenceOffset: 0xc9,
    ReferenceTimestamp: 0xca,
    EncryptedBlock: 0xaf,
    Tracks: 0x1654ae6b,
    TrackEntry: 0xae,
    TrackNumber: 0xd7,
    TrackUID: 0x73c5,
    TrackType: 0x83,
    FlagEnabled: 0xb9,
    FlagDefault: 0x88,
    FlagForced: 0x55aa,
    FlagHearingImpaired: 0x55ab,
    FlagVisualImpaired: 0x55ac,
    FlagTextDescriptions: 0x55ad,
    FlagOriginal: 0x55ae,
    FlagCommentary: 0x55af,
    FlagLacing: 0x9c,
    MinCache: 0x6de7,
    MaxCache: 0x6df8,
    DefaultDuration: 0x23e383,
    DefaultDecodedFieldDuration: 0x234e7a,
    TrackTimestampScale: 0x23314f,
    TrackOffset: 0x537f,
    MaxBlockAdditionID: 0x55ee,
    BlockAdditionMapping: 0x41e4,
    BlockAddIDValue: 0x41f0,
    BlockAddIDName: 0x41a4,
    BlockAddIDType: 0x41e7,
    BlockAddIDExtraData: 0x41ed,
    Name: 0x536e,
    Language: 0x22b59c,
    LanguageBCP47: 0x22b59d,
    CodecID: 0x86,
    CodecPrivate: 0x63a2,
    CodecName: 0x258688,
    AttachmentLink: 0x7446,
    CodecSettings: 0x3a9697,
    CodecInfoURL: 0x3b4040,
    CodecDownloadURL: 0x26b240,
    CodecDecodeAll: 0xaa,
    TrackOverlay: 0x6fab,
    CodecDelay: 0x56aa,
    SeekPreRoll: 0x56bb,
    TrackTranslate: 0x6624,
    TrackTranslateTrackID: 0x66a5,
    TrackTranslateCodec: 0x66bf,
    TrackTranslateEditionUID: 0x66fc,
    Video: 0xe0,
    FlagInterlaced: 0x9a,
    FieldOrder: 0x9d,
    StereoMode: 0x53b8,
    AlphaMode: 0x53c0,
    OldStereoMode: 0x53b9,
    PixelWidth: 0xb0,
    PixelHeight: 0xba,
    PixelCropBottom: 0x54aa,
    PixelCropTop: 0x54bb,
    PixelCropLeft: 0x54cc,
    PixelCropRight: 0x54dd,
    DisplayWidth: 0x54b0,
    DisplayHeight: 0x54ba,
    DisplayUnit: 0x54b2,
    AspectRatioType: 0x54b3,
    UncompressedFourCC: 0x2eb524,
    GammaValue: 0x2fb523,
    FrameRate: 0x2383e3,
    Colour: 0x55b0,
    MatrixCoefficients: 0x55b1,
    BitsPerChannel: 0x55b2,
    ChromaSubsamplingHorz: 0x55b3,
    ChromaSubsamplingVert: 0x55b4,
    CbSubsamplingHorz: 0x55b5,
    CbSubsamplingVert: 0x55b6,
    ChromaSitingHorz: 0x55b7,
    ChromaSitingVert: 0x55b8,
    Range: 0x55b9,
    TransferCharacteristics: 0x55ba,
    Primaries: 0x55bb,
    MaxCLL: 0x55bc,
    MaxFALL: 0x55bd,
    MasteringMetadata: 0x55d0,
    PrimaryRChromaticityX: 0x55d1,
    PrimaryRChromaticityY: 0x55d2,
    PrimaryGChromaticityX: 0x55d3,
    PrimaryGChromaticityY: 0x55d4,
    PrimaryBChromaticityX: 0x55d5,
    PrimaryBChromaticityY: 0x55d6,
    WhitePointChromaticityX: 0x55d7,
    WhitePointChromaticityY: 0x55d8,
    LuminanceMax: 0x55d9,
    LuminanceMin: 0x55da,
    Projection: 0x7670,
    ProjectionType: 0x7671,
    ProjectionPrivate: 0x7672,
    ProjectionPoseYaw: 0x7673,
    ProjectionPosePitch: 0x7674,
    ProjectionPoseRoll: 0x7675,
    Audio: 0xe1,
    SamplingFrequency: 0xb5,
    OutputSamplingFrequency: 0x78b5,
    Channels: 0x9f,
    ChannelPositions: 0x7d7b,
    BitDepth: 0x6264,
    Emphasis: 0x52f1,
    TrackOperation: 0xe2,
    TrackCombinePlanes: 0xe3,
    TrackPlane: 0xe4,
    TrackPlaneUID: 0xe5,
    TrackPlaneType: 0xe6,
    TrackJoinBlocks: 0xe9,
    TrackJoinUID: 0xed,
    TrickTrackUID: 0xc0,
    TrickTrackSegmentUID: 0xc1,
    TrickTrackFlag: 0xc6,
    TrickMasterTrackUID: 0xc7,
    TrickMasterTrackSegmentUID: 0xc4,
    ContentEncodings: 0x6d80,
    ContentEncoding: 0x6240,
    ContentEncodingOrder: 0x5031,
    ContentEncodingScope: 0x5032,
    ContentEncodingType: 0x5033,
    ContentCompression: 0x5034,
    ContentCompAlgo: 0x4254,
    ContentCompSettings: 0x4255,
    ContentEncryption: 0x5035,
    ContentEncAlgo: 0x47e1,
    ContentEncKeyID: 0x47e2,
    ContentEncAESSettings: 0x47e7,
    AESSettingsCipherMode: 0x47e8,
    ContentSignature: 0x47e3,
    ContentSigKeyID: 0x47e4,
    ContentSigAlgo: 0x47e5,
    ContentSigHashAlgo: 0x47e6,
    Cues: 0x1c53bb6b,
    CuePoint: 0xbb,
    CueTime: 0xb3,
    CueTrackPositions: 0xb7,
    CueTrack: 0xf7,
    CueClusterPosition: 0xf1,
    CueRelativePosition: 0xf0,
    CueDuration: 0xb2,
    CueBlockNumber: 0x5378,
    CueCodecState: 0xea,
    CueReference: 0xdb,
    CueRefTime: 0x96,
    CueRefCluster: 0x97,
    CueRefNumber: 0x535f,
    CueRefCodecState: 0xeb,
    Attachments: 0x1941a469,
    AttachedFile: 0x61a7,
    FileDescription: 0x467e,
    FileName: 0x466e,
    FileMediaType: 0x4660,
    FileData: 0x465c,
    FileUID: 0x46ae,
    FileReferral: 0x4675,
    FileUsedStartTime: 0x4661,
    FileUsedEndTime: 0x4662,
    Chapters: 0x1043a770,
    EditionEntry: 0x45b9,
    EditionUID: 0x45bc,
    EditionFlagHidden: 0x45bd,
    EditionFlagDefault: 0x45db,
    EditionFlagOrdered: 0x45dd,
    EditionDisplay: 0x4520,
    EditionString: 0x4521,
    EditionLanguageIETF: 0x45e4,
    ChapterAtom: 0xb6,
    ChapterUID: 0x73c4,
    ChapterStringUID: 0x5654,
    ChapterTimeStart: 0x91,
    ChapterTimeEnd: 0x92,
    ChapterFlagHidden: 0x98,
    ChapterFlagEnabled: 0x4598,
    ChapterSegmentUUID: 0x6e67,
    ChapterSkipType: 0x4588,
    ChapterSegmentEditionUID: 0x6ebc,
    ChapterPhysicalEquiv: 0x63c3,
    ChapterTrack: 0x8f,
    ChapterTrackUID: 0x89,
    ChapterDisplay: 0x80,
    ChapString: 0x85,
    ChapLanguage: 0x437c,
    ChapLanguageBCP47: 0x437d,
    ChapCountry: 0x437e,
    ChapProcess: 0x6944,
    ChapProcessCodecID: 0x6955,
    ChapProcessPrivate: 0x450d,
    ChapProcessCommand: 0x6911,
    ChapProcessTime: 0x6922,
    ChapProcessData: 0x6933,
    Tags: 0x1254c367,
    Tag: 0x7373,
    Targets: 0x63c0,
    TargetTypeValue: 0x68ca,
    TargetType: 0x63ca,
    TagTrackUID: 0x63c5,
    TagEditionUID: 0x63c9,
    TagChapterUID: 0x63c4,
    TagAttachmentUID: 0x63c6,
    SimpleTag: 0x67c8,
    TagName: 0x45a3,
    TagLanguage: 0x447a,
    TagLanguageBCP47: 0x447b,
    TagDefault: 0x4484,
    TagDefaultBogus: 0x44b4,
    TagString: 0x4487,
    TagBinary: 0x4485,
    EBML: 0x1a45dfa3,
    EBMLVersion: 0x4286,
    EBMLReadVersion: 0x42f7,
    DocType: 0x4282,
    DocTypeVersion: 0x4287,
    DocTypeReadVersion: 0x4285,
    DocTypeExtension: 0x4281,
    DocTypeExtensionName: 0x4283,
    DocTypeExtensionVersion: 0x4284,
    Void: 0xec,
    CRC_32: 0xbf,
    SignatureSlot: 0x1b538667,
    SignatureAlgo: 0x7e8a,
    SignatureHash: 0x7e9a,
    SignaturePublicKey: 0x7ea5,
    Signature: 0x7eb5,
    SignatureElements: 0x7e5b,
    SignatureElementList: 0x7e7b,
    SignedElement: 0x6532,
    TimecodeScaleDenominator: 0x2ad7b2,
  }
};
