# 🕵️ Locate ANY APP

<!--Badges-->
<!--⚠️WARNING: This section was generated by https://github.com/hejny/batch-project-editor/blob/main/src/workflows/800-badges/badges.ts so every manual change will be overwritten.-->


[![License of Locate ANY APP](https://img.shields.io/github/license/hejny/locate-app.svg?style=flat)](https://github.com/hejny/locate-app/blob/main/LICENSE)
[![NPM Version of Locate ANY APP](https://badge.fury.io/js/locate-app.svg)](https://www.npmjs.com/package/locate-app)
[![Quality of package Locate ANY APP](https://packagequality.com/shield/locate-app.svg)](https://packagequality.com/#?package=locate-app)
[![Known Vulnerabilities](https://snyk.io/test/github/hejny/locate-app/badge.svg)](https://snyk.io/test/github/hejny/locate-app)
[![Issues](https://img.shields.io/github/issues/hejny/locate-app.svg?style=flat)](https://github.com/hejny/locate-app/issues)
[![Socket](https://socket.dev/api/badge/npm/package/locate-app)](https://socket.dev/npm/package/locate-app)

<!--/Badges-->

Find apps installed on your system. This util will help to find executables of a known app like Chrome, Firefox,... on Windows, Linux, and macOS out of the box.

<!--Wallpaper-->
<!--⚠️WARNING: This section was generated by https://github.com/hejny/batch-project-editor/blob/main/src//workflows/315-ai-generated-wallpaper/4-aiGeneratedWallpaperUseInReadme.ts so every manual change will be overwritten.-->

[![Wallpaper of 🕵️ Locate ANY APP](assets/ai/wallpaper/gallery/0adf1512-09a8-438c-aa3e-c17777503379-0_0.png)](https://www.midjourney.com/app/jobs/0adf1512-09a8-438c-aa3e-c17777503379)

<!--/Wallpaper-->

<!--Custom-Wallpaper-->

![Social media wallpaper for Locate app project](/media/locate-app-social-wallpaper.png)

<!--/Custom-Wallpaper-->

## 🔎 Locating the Firefox

Via this utility it is extremely easy to get the path to some browser:

```typescript
import { locateChrome } from 'locate-app';

const executablePathOfFirefox = await locateFirefox();
```

Then you can use **executablePathOfFirefox to open _(spawn)_ the browser:**

```typescript
import { locateChrome } from 'locate-app';
import { spawn } from 'child_process';

spawn(await locateFirefox(), ['https://github.com/hejny/locate-app']);
```

_Locate app will ensure that file is executable. If it can not find the browser it will throw an error._
Or you can use the path to the browser as you want:

## 🔍 Locating the Chrome

```typescript
import { locateChrome } from 'locate-app';

const executablePathOfChrome = await locateChrome();
```

```typescript
import { locateChrome } from 'locate-app';
import { spawn } from 'child_process';

spawn(await locateChrome(), ['https://github.com/hejny/locate-app']);
```

_Locate app will ensure that file is executable. If it can not find the browser it will throw an error._
Or you can use the path to the browser as you want:

```typescript
import { locateChrome } from 'locate-app';
import puppeteer from 'puppeteer-core';

await puppeteer.launch({ executablePath: await locateChrome() });
```

## 🔎 Locating arbitrary browser

You can use functions [locateChrome](https://hejny.github.io/locate-app/modules.html#locateChrome), [locateEdge](https://hejny.github.io/locate-app/modules.html#locateEdge), [locateFirefox](https://hejny.github.io/locate-app/modules.html#locateFirefox), [locateInternetExplorer](https://hejny.github.io/locate-app/modules.html#locateInternetExplorer), [locateSafari](https://hejny.github.io/locate-app/modules.html#locateSafari) or **universal [locateBrowser](https://hejny.github.io/locate-app/modules.html#locateBrowser)** which recieves param which browser to locate:

```typescript
import { locateBrowser } from 'locate-app';

const executablePathOfSafari = await locateBrowser('safari');
const executablePathOfEdge = await locateBrowser('edge');
```

## 👨‍💻 Locating VSCode

```typescript
import { locateChrome } from 'locate-app';
import { spawn } from 'child_process';

spawn(await locateVSCode(), ['~/work/my-awesome-project']);
```

## 🔍 Locating arbitrary app

You can locate any app very easily. You need to provide breadcrumbs for each platform. If you omit some platform it does not matter but there will be an error in runtime if you try to run it on the omitted os.

```typescript
import { locateApp } from 'locate-app';

await locateApp({
    appName: 'Chrome',
    linuxWhich: 'google-chrome',
    windowsSuffix: '\\Google\\Chrome\\Application\\chrome.exe',
    macOsName: 'Google Chrome',
});
```

## 📖 Documentation

The project is fully typed so you probably do not need the documentation. But if so, here it is
https://hejny.github.io/locate-app/index.html

## ⌚ Changelog

See [CHANGELOG.md](./CHANGELOG.md)

<!--Contributing-->
<!--⚠️WARNING: This section was generated by https://github.com/hejny/batch-project-editor/blob/main/src/workflows/810-contributing/contributing.ts so every manual change will be overwritten.-->

## 🖋️ Contributing

I am open to pull requests, feedback, and suggestions. Or if you like this utility, you can [☕ buy me a coffee](https://www.buymeacoffee.com/hejny) or [donate via cryptocurrencies](https://github.com/hejny/hejny/blob/main/documents/crypto.md).

You can also ⭐ star the locate-app package, [follow me on GitHub](https://github.com/hejny) or [various other social networks](https://www.pavolhejny.com/contact/).

<!--/Contributing-->

<!--Partners-->
<!--⚠️WARNING: This section was generated by https://github.com/hejny/batch-project-editor/blob/main/src/workflows/820-partners/partners.ts so every manual change will be overwritten.-->

## ✨ Partners


<a href="https://collboard.com/" title="Collboard"><img src="https://collboard.fra1.cdn.digitaloceanspaces.com/assets/18.12.1/logo-small.png#gh-light-mode-only" alt="Collboard" height="60"/></a>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
<a href="https://webgpt.cz/?partner=ph&utm_medium=referral&utm_source=github-readme&utm_campaign=partner-ph" title="WebGPT"><img src="https://webgpt.cz/_next/static/media/webgpt-black.8d958d25.png#gh-light-mode-only" alt="WebGPT" height="60"/></a>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
<a href="https://github.com/webgptorg/promptbook" title="Promptbook"><img src="https://raw.githubusercontent.com/webgptorg/promptbook/main/other/design/logo.png#gh-light-mode-only" alt="Promptbook" height="60"/></a>


[Become a partner](https://www.pavolhejny.com/contact/)

<!--/Partners-->
