import browser from '../../modules/browser';
import { CodecMimeType } from './CodecMimeType';
// Default value for assumed downlink bandwidth for the local endpoint which tells the bridge to use its own calculated
// BWE value while determining the number of video streams to route to the endpoint.
export const ASSUMED_BANDWIDTH_BPS = -1;
// Default lastN value to be used while ramping up lastN after a cpu limitation ceases to exist (if -1 or no value is
// passed in config.js for channelLastN).
export const DEFAULT_LAST_N = 25;
// LastN value to be signaled to the bridge when the local endpoint wants to receive all the remote video sources in
// the call.
export const LAST_N_UNLIMITED = -1;
// Default simulcast encodings config.
export const SIM_LAYERS = [
    {
        rid: '1',
        scaleFactor: 4.0
    },
    {
        rid: '2',
        scaleFactor: 2.0
    },
    {
        rid: '3',
        scaleFactor: 1.0
    }
];
/**
 * The ssrc-group semantics for SSRCs related to the video streams.
 */
export var SSRC_GROUP_SEMANTICS;
(function (SSRC_GROUP_SEMANTICS) {
    // The semantics for group of SSRCs belonging to the same stream, primary and RTX.
    SSRC_GROUP_SEMANTICS["FID"] = "FID";
    // The semantics for group with primary SSRCs for each of the simulcast streams.
    SSRC_GROUP_SEMANTICS["SIM"] = "SIM";
})(SSRC_GROUP_SEMANTICS || (SSRC_GROUP_SEMANTICS = {}));
/**
 * Standard scalability mode settings for different video codecs and the default bitrates.
 */
export const STANDARD_CODEC_SETTINGS = {
    av1: {
        maxBitratesVideo: {
            fullHd: 2000000,
            high: 1000000,
            low: 100000,
            none: 0,
            ssHigh: 2500000,
            standard: 300000,
            ultraHd: 4000000
        },
        scalabilityModeEnabled: browser.supportsScalabilityModeAPI(),
        useKSVC: browser.supportsSVC(),
        useSimulcast: !browser.supportsSVC(),
    },
    h264: {
        maxBitratesVideo: {
            fullHd: 4000000,
            high: 2000000,
            low: 400000,
            none: 0,
            ssHigh: 2500000,
            standard: 800000,
            ultraHd: 8000000,
        },
        scalabilityModeEnabled: browser.supportsScalabilityModeAPI()
    },
    vp8: {
        maxBitratesVideo: {
            fullHd: 3000000,
            high: 1500000,
            low: 200000,
            none: 0,
            ssHigh: 2500000,
            standard: 500000,
            ultraHd: 6000000,
        },
        scalabilityModeEnabled: false
    },
    vp9: {
        maxBitratesVideo: {
            fullHd: 2500000,
            high: 1200000,
            low: 100000,
            none: 0,
            ssHigh: 2500000,
            standard: 300000,
            ultraHd: 5000000
        },
        scalabilityModeEnabled: browser.supportsScalabilityModeAPI(),
        useKSVC: browser.supportsSVC(),
        useSimulcast: !browser.supportsSVC(),
    }
};
/**
 * Video codecs in descending order of complexity for camera and desktop video types based on the results of manual
 * performance tests on different platforms. When a CPU limitation is encountered, client switches the call to use the
 * next codec in the list.
 */
export const VIDEO_CODECS_BY_COMPLEXITY = {
    'camera': [
        CodecMimeType.AV1,
        CodecMimeType.VP9,
        CodecMimeType.VP8
    ],
    'desktop': [
        CodecMimeType.VP9,
        CodecMimeType.VP8,
        CodecMimeType.AV1
    ]
};
/**
 * Standard video resolutions and the corresponding quality level that will be picked for the given resolution.
 * For quality levels:
 * 'high' and above - the encoder will be configured to encode 3 spatial layers.
 * 'standard' - the encoder will be configured to encode 2 spatial laters.
 * 'low' - the encoder will be configured to encode only 1 spatial layer.
 * In all the above cases, each of the layers will again have 3 temporal layers, except for VP8 codec for which only
 * 2 temporal layers are configured by default.
 */
export const VIDEO_QUALITY_LEVELS = [
    {
        height: 2160,
        level: 'ultraHd'
    },
    {
        height: 1080,
        level: 'fullHd'
    },
    {
        height: 720,
        level: 'high'
    },
    {
        height: 540,
        level: 'standard'
    },
    {
        height: 480,
        level: 'standard'
    },
    {
        height: 360,
        level: 'standard'
    },
    {
        height: 270,
        level: 'low'
    },
    {
        height: 180,
        level: 'low'
    },
    {
        height: 90,
        level: 'low'
    },
    {
        height: 0,
        level: 'none'
    }
];
/**
 * Enumerate the supported video resolutions.
 */
export var VIDEO_QUALITY_SETTINGS;
(function (VIDEO_QUALITY_SETTINGS) {
    // 1920x1080 or full High Definition.
    VIDEO_QUALITY_SETTINGS["FULL"] = "fullHd";
    // 1280x720 or High Definition.
    VIDEO_QUALITY_SETTINGS["HIGH"] = "high";
    // 320x180 or Low Definition.
    VIDEO_QUALITY_SETTINGS["LOW"] = "low";
    // When the camera is turned off.
    VIDEO_QUALITY_SETTINGS["NONE"] = "none";
    // 640x360 or Standard Definition.
    VIDEO_QUALITY_SETTINGS["STANDARD"] = "standard";
    // 3840x2160 or 4k.
    VIDEO_QUALITY_SETTINGS["ULTRA"] = "ultraHd";
})(VIDEO_QUALITY_SETTINGS || (VIDEO_QUALITY_SETTINGS = {}));
//# sourceMappingURL=StandardVideoQualitySettings.js.map