/**
 * Enumeration of the codec mime types
 * @type {{AV1: string, H264: string, OPUS: string, RED: string, ULPFEC: string, VP8: string, VP9: string}}
 */
export var CodecMimeType;
(function (CodecMimeType) {
    /**
     * AV1 codec mime type.
     */
    CodecMimeType["AV1"] = "av1";
    /**
     * The h264 codec mime type.
     */
    CodecMimeType["H264"] = "h264";
    /**
     * The opus codec mime type.
     */
    CodecMimeType["OPUS"] = "opus";
    /**
     * The red codec mime type.
     */
    CodecMimeType["RED"] = "red";
    /**
     * The ulpfec codec mime type.
     */
    CodecMimeType["ULPFEC"] = "ulpfec";
    /**
     * The vp8 codec mime type.
     */
    CodecMimeType["VP8"] = "vp8";
    /**
     * The vp9 codec mime type.
     */
    CodecMimeType["VP9"] = "vp9";
})(CodecMimeType || (CodecMimeType = {}));
//# sourceMappingURL=CodecMimeType.js.map