import { expect, matchers } from './index.js';
import { SoftAssertService } from './softAssert.js';
const createSoftExpect = (actual) => {
    const softService = SoftAssertService.getInstance();
    return new Proxy({}, {
        get(target, prop) {
            const propName = String(prop);
            if (propName === 'not') {
                return createSoftNotProxy(actual, softService);
            }
            if (propName === 'resolves' || propName === 'rejects') {
                return createSoftChainProxy(actual, propName, softService);
            }
            if (matchers.has(propName)) {
                return createSoftMatcher(actual, propName, softService);
            }
            return undefined;
        }
    });
};
const createSoftNotProxy = (actual, softService) => {
    return new Proxy({}, {
        get(target, prop) {
            const propName = String(prop);
            if (matchers.has(propName)) {
                return createSoftMatcher(actual, propName, softService, 'not');
            }
            return undefined;
        }
    });
};
const createSoftChainProxy = (actual, chainType, softService) => {
    return new Proxy({}, {
        get(target, prop) {
            const propName = String(prop);
            if (matchers.has(propName)) {
                return createSoftMatcher(actual, propName, softService, chainType);
            }
            return undefined;
        }
    });
};
const createSoftMatcher = (actual, matcherName, softService, prefix) => {
    return async (...args) => {
        try {
            let expectChain = expect(actual);
            if (prefix === 'not') {
                expectChain = expectChain.not;
            }
            else if (prefix === 'resolves') {
                expectChain = expectChain.resolves;
            }
            else if (prefix === 'rejects') {
                expectChain = expectChain.rejects;
            }
            return await expectChain[matcherName](...args);
        }
        catch (error) {
            const fullMatcherName = prefix ? `${prefix}.${matcherName}` : matcherName;
            softService.addFailure(error, fullMatcherName);
            return {
                pass: true,
                message: () => `Soft assertion failed: ${fullMatcherName}`
            };
        }
    };
};
export default createSoftExpect;
