import { SoftAssertService } from './softAssert.js';
export class SoftAssertionService {
    constructor(serviceOptions) {
        this.softAssertService = SoftAssertService.getInstance();
        this.options = {
            autoAssertOnTestEnd: true,
            ...serviceOptions
        };
    }
    beforeTest(test) {
        const testId = this.getTestId(test);
        this.softAssertService.setCurrentTest(testId, test.title, test.file);
    }
    beforeStep(step, scenario) {
        const stepId = `${scenario.uri || ''}:${scenario.name || ''}:${step.text || ''}`;
        this.softAssertService.setCurrentTest(stepId, step.text, scenario.uri);
    }
    afterTest(test, _, result) {
        if (!result.error && this.options.autoAssertOnTestEnd) {
            try {
                const testId = this.getTestId(test);
                this.softAssertService.assertNoFailures(testId);
            }
            catch (error) {
                result.error = error;
                result.passed = false;
            }
        }
        this.softAssertService.clearCurrentTest();
    }
    afterStep(step, scenario, result) {
        if (result.passed) {
            try {
                const stepId = `${scenario.uri || ''}:${scenario.name || ''}:${step.text || ''}`;
                this.softAssertService.assertNoFailures(stepId);
            }
            catch (error) {
                result.error = error;
                result.passed = false;
            }
        }
        this.softAssertService.clearCurrentTest();
    }
    getTestId(test) {
        return `${test.file || ''}:${test.parent || ''}:${test.title || ''}`;
    }
}
