var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _WebdriverIOSnapshotEnvironment_resolveSnapshotPath, _SnapshotService_instances, _SnapshotService_currentFilePath, _SnapshotService_currentTestName, _SnapshotService_options, _SnapshotService_snapshotResults, _SnapshotService_snapshotClient, _SnapshotService_isEqual;
import { expect } from '@wdio/globals';
import { SnapshotClient } from '@vitest/snapshot';
import { NodeSnapshotEnvironment } from '@vitest/snapshot/environment';
let service;
class WebdriverIOSnapshotEnvironment extends NodeSnapshotEnvironment {
    constructor(resolveSnapshotPath) {
        super({});
        _WebdriverIOSnapshotEnvironment_resolveSnapshotPath.set(this, void 0);
        __classPrivateFieldSet(this, _WebdriverIOSnapshotEnvironment_resolveSnapshotPath, resolveSnapshotPath, "f");
    }
    async resolvePath(filepath) {
        if (__classPrivateFieldGet(this, _WebdriverIOSnapshotEnvironment_resolveSnapshotPath, "f")) {
            return __classPrivateFieldGet(this, _WebdriverIOSnapshotEnvironment_resolveSnapshotPath, "f").call(this, filepath, '.snap');
        }
        return super.resolvePath(filepath);
    }
}
_WebdriverIOSnapshotEnvironment_resolveSnapshotPath = new WeakMap();
export class SnapshotService {
    constructor(options) {
        _SnapshotService_instances.add(this);
        _SnapshotService_currentFilePath.set(this, void 0);
        _SnapshotService_currentTestName.set(this, void 0);
        _SnapshotService_options.set(this, void 0);
        _SnapshotService_snapshotResults.set(this, []);
        _SnapshotService_snapshotClient.set(this, new SnapshotClient({
            isEqual: __classPrivateFieldGet(this, _SnapshotService_instances, "m", _SnapshotService_isEqual).bind(this),
        }));
        const updateSnapshot = (Boolean(process.env.CI) && !options?.updateState)
            ? 'none'
            : options?.updateState
                ? options.updateState
                : 'new';
        const snapshotFormatConfig = options?.snapshotFormat ? {
            printBasicPrototype: false,
            escapeString: false,
            ...options.snapshotFormat
        } : undefined;
        __classPrivateFieldSet(this, _SnapshotService_options, {
            updateSnapshot,
            snapshotEnvironment: new WebdriverIOSnapshotEnvironment(options?.resolveSnapshotPath),
            ...(snapshotFormatConfig && { snapshotFormat: snapshotFormatConfig })
        }, "f");
    }
    get currentFilePath() {
        return __classPrivateFieldGet(this, _SnapshotService_currentFilePath, "f");
    }
    get currentTestName() {
        return __classPrivateFieldGet(this, _SnapshotService_currentTestName, "f");
    }
    get client() {
        return __classPrivateFieldGet(this, _SnapshotService_snapshotClient, "f");
    }
    get results() {
        return __classPrivateFieldGet(this, _SnapshotService_snapshotResults, "f");
    }
    async beforeTest(test) {
        __classPrivateFieldSet(this, _SnapshotService_currentFilePath, test.file, "f");
        __classPrivateFieldSet(this, _SnapshotService_currentTestName, `${test.parent} > ${test.title}`, "f");
        await __classPrivateFieldGet(this, _SnapshotService_snapshotClient, "f").setup(test.file, __classPrivateFieldGet(this, _SnapshotService_options, "f"));
    }
    async beforeStep(step, scenario) {
        const file = scenario.uri;
        const testName = `${scenario.name} > ${step.text}`;
        __classPrivateFieldSet(this, _SnapshotService_currentFilePath, file, "f");
        __classPrivateFieldSet(this, _SnapshotService_currentTestName, testName, "f");
        await __classPrivateFieldGet(this, _SnapshotService_snapshotClient, "f").setup(file, __classPrivateFieldGet(this, _SnapshotService_options, "f"));
    }
    async after() {
        if (!__classPrivateFieldGet(this, _SnapshotService_currentFilePath, "f")) {
            return;
        }
        const result = await __classPrivateFieldGet(this, _SnapshotService_snapshotClient, "f").finish(__classPrivateFieldGet(this, _SnapshotService_currentFilePath, "f"));
        if (!result) {
            return;
        }
        __classPrivateFieldGet(this, _SnapshotService_snapshotResults, "f").push(result);
    }
    static initiate(options) {
        if (!service) {
            service = new SnapshotService(options);
        }
        return service;
    }
}
_SnapshotService_currentFilePath = new WeakMap(), _SnapshotService_currentTestName = new WeakMap(), _SnapshotService_options = new WeakMap(), _SnapshotService_snapshotResults = new WeakMap(), _SnapshotService_snapshotClient = new WeakMap(), _SnapshotService_instances = new WeakSet(), _SnapshotService_isEqual = function _SnapshotService_isEqual(received, expected) {
    try {
        expect(received).toBe(expected);
        return true;
    }
    catch {
        return false;
    }
};
