import { waitUntil, enhanceError, compareNumbers } from '../../utils.js';
import { numberError } from '../../util/formatMessage.js';
import { DEFAULT_OPTIONS } from '../../constants.js';
export async function toBeRequestedTimes(received, expectedValue = {}, options = DEFAULT_OPTIONS) {
    const isNot = this.isNot || false;
    const { expectation = `called${typeof expectedValue === 'number' ? ' ' + expectedValue : ''} time${expectedValue !== 1 ? 's' : ''}`, verb = 'be' } = this;
    await options.beforeAssertion?.({
        matcherName: 'toBeRequestedTimes',
        expectedValue,
        options,
    });
    const numberOptions = typeof expectedValue === 'number'
        ? { eq: expectedValue }
        : expectedValue || {};
    let actual;
    const pass = await waitUntil(async () => {
        actual = received.calls.length;
        return compareNumbers(actual, numberOptions);
    }, isNot, { ...numberOptions, ...options });
    const error = numberError(numberOptions);
    const message = enhanceError('mock', error, actual, this, verb, expectation, '', numberOptions);
    const result = {
        pass,
        message: () => message
    };
    await options.afterAssertion?.({
        matcherName: 'toBeRequestedTimes',
        expectedValue,
        options,
        result
    });
    return result;
}
