import { DEFAULT_OPTIONS } from '../../constants.js';
import { compareNumbers, enhanceError, executeCommand, numberError, waitUntil, } from '../../utils.js';
async function condition(el, width, options) {
    const actualWidth = await el.getSize('width');
    return {
        result: compareNumbers(actualWidth, options),
        value: actualWidth
    };
}
export async function toHaveWidth(received, expectedValue, options = DEFAULT_OPTIONS) {
    const isNot = this.isNot;
    const { expectation = 'width', verb = 'have' } = this;
    await options.beforeAssertion?.({
        matcherName: 'toHaveWidth',
        expectedValue,
        options,
    });
    let numberOptions;
    if (typeof expectedValue === 'number') {
        numberOptions = { eq: expectedValue };
    }
    else if (!expectedValue || (typeof expectedValue.eq !== 'number' && typeof expectedValue.gte !== 'number' && typeof expectedValue.lte !== 'number')) {
        throw new Error('Invalid params passed to toHaveHeight.');
    }
    else {
        numberOptions = expectedValue;
    }
    let el = await received?.getElement();
    let actualWidth;
    const pass = await waitUntil(async () => {
        const result = await executeCommand.call(this, el, condition, numberOptions, [expectedValue, numberOptions]);
        el = result.el;
        actualWidth = result.values;
        return result.success;
    }, isNot, { ...numberOptions, ...options });
    const error = numberError(numberOptions);
    const message = enhanceError(el, error, actualWidth, this, verb, expectation, '', options);
    const result = {
        pass,
        message: () => message
    };
    await options.afterAssertion?.({
        matcherName: 'toHaveWidth',
        expectedValue,
        options,
        result
    });
    return result;
}
