import { DEFAULT_OPTIONS } from '../../constants.js';
import { compareStyle, enhanceError, executeCommand, waitUntil, wrapExpectedWithArray } from '../../utils.js';
async function condition(el, style, options) {
    return compareStyle(el, style, options);
}
export async function toHaveStyle(received, expectedValue, options = DEFAULT_OPTIONS) {
    const isNot = this.isNot;
    const { expectation = 'style', verb = 'have' } = this;
    await options.beforeAssertion?.({
        matcherName: 'toHaveStyle',
        expectedValue,
        options,
    });
    let el = await received?.getElement();
    let actualStyle;
    const pass = await waitUntil(async () => {
        const result = await executeCommand.call(this, el, condition, options, [expectedValue, options]);
        el = result.el;
        actualStyle = result.values;
        return result.success;
    }, isNot, options);
    const message = enhanceError(el, wrapExpectedWithArray(el, actualStyle, expectedValue), actualStyle, this, verb, expectation, '', options);
    const result = {
        pass,
        message: () => message
    };
    await options.afterAssertion?.({
        matcherName: 'toHaveStyle',
        expectedValue,
        options,
        result
    });
    return result;
}
