import { DEFAULT_OPTIONS } from '../../constants.js';
import { compareObject, enhanceError, executeCommand, waitUntil, wrapExpectedWithArray, } from '../../utils.js';
async function condition(el, size) {
    const actualSize = await el.getSize();
    return compareObject(actualSize, size);
}
export async function toHaveSize(received, expectedValue, options = DEFAULT_OPTIONS) {
    const isNot = this.isNot;
    const { expectation = 'size', verb = 'have' } = this;
    await options.beforeAssertion?.({
        matcherName: 'toHaveSize',
        expectedValue,
        options,
    });
    let el = await received?.getElement();
    let actualSize;
    const pass = await waitUntil(async () => {
        const result = await executeCommand.call(this, el, condition, options, [expectedValue, options]);
        el = result.el;
        actualSize = result.values;
        return result.success;
    }, isNot, options);
    const message = enhanceError(el, wrapExpectedWithArray(el, actualSize, expectedValue), actualSize, this, verb, expectation, '', options);
    const result = {
        pass,
        message: () => message
    };
    await options.afterAssertion?.({
        matcherName: 'toHaveSize',
        expectedValue,
        options,
        result
    });
    return result;
}
