import { toHaveAttributeAndValue } from './toHaveAttribute.js';
import { DEFAULT_OPTIONS } from '../../constants.js';
export async function toHaveHref(el, expectedValue, options = DEFAULT_OPTIONS) {
    await options.beforeAssertion?.({
        matcherName: 'toHaveHref',
        expectedValue,
        options,
    });
    const result = await toHaveAttributeAndValue.call(this, el, 'href', expectedValue, options);
    await options.afterAssertion?.({
        matcherName: 'toHaveHref',
        expectedValue,
        options,
        result
    });
    return result;
}
export const toHaveLink = toHaveHref;
