import { DEFAULT_OPTIONS } from '../../constants.js';
import { compareNumbers, enhanceError, executeCommand, numberError, waitUntil, } from '../../utils.js';
async function condition(el, height, options) {
    const actualHeight = await el.getSize('height');
    return {
        result: compareNumbers(actualHeight, options),
        value: actualHeight
    };
}
export async function toHaveHeight(received, expectedValue, options = DEFAULT_OPTIONS) {
    const isNot = this.isNot;
    const { expectation = 'height', verb = 'have' } = this;
    await options.beforeAssertion?.({
        matcherName: 'toHaveHeight',
        expectedValue,
        options,
    });
    let numberOptions;
    if (typeof expectedValue === 'number') {
        numberOptions = { eq: expectedValue };
    }
    else if (!expectedValue || (typeof expectedValue.eq !== 'number' && typeof expectedValue.gte !== 'number' && typeof expectedValue.lte !== 'number')) {
        throw new Error('Invalid params passed to toHaveHeight.');
    }
    else {
        numberOptions = expectedValue;
    }
    let el = await received?.getElement();
    let actualHeight;
    const pass = await waitUntil(async () => {
        const result = await executeCommand.call(this, el, condition, numberOptions, [expectedValue, numberOptions]);
        el = result.el;
        actualHeight = result.values;
        return result.success;
    }, isNot, { ...numberOptions, ...options });
    const error = numberError(numberOptions);
    const message = enhanceError(el, error, actualHeight, this, verb, expectation, '', options);
    const result = {
        pass,
        message: () => message
    };
    await options.afterAssertion?.({
        matcherName: 'toHaveHeight',
        expectedValue,
        options,
        result
    });
    return result;
}
