import { DEFAULT_OPTIONS } from '../../constants.js';
import { compareText, enhanceError, executeCommand, waitUntil, wrapExpectedWithArray } from '../../utils.js';
async function condition(el, property, value, options = DEFAULT_OPTIONS) {
    const { asString = false } = options;
    let prop = await el.getProperty(property);
    if (prop === null || prop === undefined) {
        return { result: false, value: prop };
    }
    if (value === null) {
        return { result: true, value: prop };
    }
    if (!(value instanceof RegExp) && typeof prop !== 'string' && !asString) {
        return { result: prop === value, value: prop };
    }
    prop = prop.toString();
    return compareText(prop, value, options);
}
export async function toHaveElementProperty(received, property, value, options = DEFAULT_OPTIONS) {
    const isNot = this.isNot;
    const { expectation = 'property', verb = 'have' } = this;
    await options.beforeAssertion?.({
        matcherName: 'toHaveElementProperty',
        expectedValue: [property, value],
        options,
    });
    let el = await received?.getElement();
    let prop;
    const pass = await waitUntil(async () => {
        const result = await executeCommand.call(this, el, condition, options, [property, value]);
        el = result.el;
        prop = result.values;
        return result.success;
    }, isNot, options);
    let message;
    if (value === undefined) {
        message = enhanceError(el, !isNot, pass, this, verb, expectation, property, options);
    }
    else {
        const expected = wrapExpectedWithArray(el, prop, value);
        message = enhanceError(el, expected, prop, this, verb, expectation, property, options);
    }
    const result = {
        pass,
        message: () => message
    };
    await options.afterAssertion?.({
        matcherName: 'toHaveElementProperty',
        expectedValue: [property, value],
        options,
        result
    });
    return result;
}
