import { DEFAULT_OPTIONS } from '../../constants.js';
import { compareText, compareTextWithArray, enhanceError, executeCommand, waitUntil, wrapExpectedWithArray } from '../../utils.js';
async function condition(el, role, options) {
    const actualRole = await el.getComputedRole();
    if (Array.isArray(role)) {
        return compareTextWithArray(actualRole, role, options);
    }
    return compareText(actualRole, role, options);
}
export async function toHaveComputedRole(received, expectedValue, options = DEFAULT_OPTIONS) {
    const isNot = this.isNot;
    const { expectation = 'computed role', verb = 'have' } = this;
    await options.beforeAssertion?.({
        matcherName: 'toHaveComputedRole',
        expectedValue,
        options,
    });
    let el = await received?.getElement();
    let actualRole;
    const pass = await waitUntil(async () => {
        const result = await executeCommand.call(this, el, condition, options, [expectedValue, options]);
        el = result.el;
        actualRole = result.values;
        return result.success;
    }, isNot, options);
    const message = enhanceError(el, wrapExpectedWithArray(el, actualRole, expectedValue), actualRole, this, verb, expectation, '', options);
    const result = {
        pass,
        message: () => message
    };
    await options.afterAssertion?.({
        matcherName: 'toHaveComputedRole',
        expectedValue,
        options,
        result
    });
    return result;
}
