import { DEFAULT_OPTIONS } from '../../constants.js';
import { compareNumbers, enhanceError, executeCommand, numberError, waitUntil, wrapExpectedWithArray } from '../../utils.js';
async function condition(el, options) {
    const children = await el.$$('./*').getElements();
    if (typeof options.lte !== 'number' &&
        typeof options.gte !== 'number' &&
        typeof options.eq !== 'number') {
        return {
            result: children.length > 0,
            value: children?.length
        };
    }
    return {
        result: compareNumbers(children?.length, options),
        value: children?.length
    };
}
export async function toHaveChildren(received, expectedValue, options = DEFAULT_OPTIONS) {
    const isNot = this.isNot;
    const { expectation = 'children', verb = 'have' } = this;
    await options.beforeAssertion?.({
        matcherName: 'toHaveChildren',
        expectedValue,
        options,
    });
    const numberOptions = typeof expectedValue === 'number'
        ? { eq: expectedValue }
        : expectedValue || {};
    let el = await received?.getElement();
    let children;
    const pass = await waitUntil(async () => {
        const result = await executeCommand.call(this, el, condition, numberOptions, [numberOptions]);
        el = result.el;
        children = result.values;
        return result.success;
    }, isNot, { ...numberOptions, ...options });
    const error = numberError(numberOptions);
    const expectedArray = wrapExpectedWithArray(el, children, error);
    const message = enhanceError(el, expectedArray, children, this, verb, expectation, '', numberOptions);
    const result = {
        pass,
        message: () => message
    };
    await options.afterAssertion?.({
        matcherName: 'toHaveChildren',
        expectedValue,
        options,
        result
    });
    return result;
}
