import { DEFAULT_OPTIONS } from '../../constants.js';
import { compareText, enhanceError, executeCommand, waitUntil, wrapExpectedWithArray } from '../../utils.js';
async function conditionAttr(el, attribute) {
    const attr = await el.getAttribute(attribute);
    if (typeof attr !== 'string') {
        return { result: false, value: attr };
    }
    return { result: true, value: attr };
}
async function conditionAttrAndValue(el, attribute, value, options) {
    const attr = await el.getAttribute(attribute);
    if (typeof attr !== 'string') {
        return { result: false, value: attr };
    }
    return compareText(attr, value, options);
}
export async function toHaveAttributeAndValue(received, attribute, value, options = DEFAULT_OPTIONS) {
    const isNot = this.isNot;
    const { expectation = 'attribute', verb = 'have' } = this;
    let el = await received?.getElement();
    let attr;
    const pass = await waitUntil(async () => {
        const result = await executeCommand.call(this, el, conditionAttrAndValue, options, [attribute, value, options]);
        el = result.el;
        attr = result.values;
        return result.success;
    }, isNot, options);
    const expected = wrapExpectedWithArray(el, attr, value);
    const message = enhanceError(el, expected, attr, this, verb, expectation, attribute, options);
    return {
        pass,
        message: () => message
    };
}
async function toHaveAttributeFn(received, attribute) {
    const isNot = this.isNot;
    const { expectation = 'attribute', verb = 'have' } = this;
    let el = await received;
    const pass = await waitUntil(async () => {
        const result = await executeCommand.call(this, el, conditionAttr, {}, [attribute]);
        el = result.el;
        return result.success;
    }, isNot, {});
    const message = enhanceError(el, !isNot, pass, this, verb, expectation, attribute, {});
    return {
        pass,
        message: () => message
    };
}
export async function toHaveAttribute(received, attribute, value, options = DEFAULT_OPTIONS) {
    await options.beforeAssertion?.({
        matcherName: 'toHaveAttribute',
        expectedValue: [attribute, value],
        options,
    });
    const result = typeof value !== 'undefined'
        ? await toHaveAttributeAndValue.call(this, received, attribute, value, options)
        : await toHaveAttributeFn.call(this, received, attribute);
    await options.afterAssertion?.({
        matcherName: 'toHaveAttribute',
        expectedValue: [attribute, value],
        options,
        result
    });
    return result;
}
export const toHaveAttr = toHaveAttribute;
