import logger from '@wdio/logger';
import { waitUntil, enhanceError, compareText } from '../../utils.js';
import { DEFAULT_OPTIONS } from '../../constants.js';
const log = logger('expect-webdriverio');
export async function toHaveClipboardText(browser, expectedValue, options = DEFAULT_OPTIONS) {
    const isNot = this.isNot;
    const { expectation = 'clipboard text', verb = 'have' } = this;
    await options.beforeAssertion?.({
        matcherName: 'toHaveClipboardText',
        expectedValue,
        options,
    });
    let actual;
    const pass = await waitUntil(async () => {
        await browser.setPermissions({ name: 'clipboard-read' }, 'granted')
            .catch((err) => log.warn(`Couldn't set clipboard permissions: ${err}`));
        actual = await browser.execute(() => window.navigator.clipboard.readText());
        return compareText(actual, expectedValue, options).result;
    }, isNot, options);
    const message = enhanceError('browser', expectedValue, actual, this, verb, expectation, '', options);
    const result = {
        pass,
        message: () => message
    };
    await options.afterAssertion?.({
        matcherName: 'toHaveClipboardText',
        expectedValue,
        options,
        result
    });
    return result;
}
