import { expect as expectLib } from 'expect';
import * as wdioMatchers from './matchers.js';
import { DEFAULT_OPTIONS } from './constants.js';
import createSoftExpect from './softExpect.js';
import { SoftAssertService } from './softAssert.js';
export const matchers = new Map();
const filteredMatchers = {};
const extend = expectLib.extend;
Object.keys(wdioMatchers).forEach(matcher => {
    if (typeof wdioMatchers[matcher] === 'function') {
        filteredMatchers[matcher] = wdioMatchers[matcher];
    }
});
expectLib.extend = (m) => {
    if (!m || typeof m !== 'object') {
        return;
    }
    Object.entries(m).forEach(([name, matcher]) => matchers.set(name, matcher));
    return extend(m);
};
expectLib.extend(filteredMatchers);
const expectWithSoft = expectLib;
Object.defineProperty(expectWithSoft, 'soft', {
    value: (actual) => createSoftExpect(actual)
});
Object.defineProperty(expectWithSoft, 'getSoftFailures', {
    value: (testId) => SoftAssertService.getInstance().getFailures(testId)
});
Object.defineProperty(expectWithSoft, 'assertSoftFailures', {
    value: (testId) => SoftAssertService.getInstance().assertNoFailures(testId)
});
Object.defineProperty(expectWithSoft, 'clearSoftFailures', {
    value: (testId) => SoftAssertService.getInstance().clearFailures(testId)
});
export const expect = expectWithSoft;
export const getConfig = () => DEFAULT_OPTIONS;
export const setDefaultOptions = (options = {}) => {
    Object.entries(options).forEach(([key, value]) => {
        if (key in DEFAULT_OPTIONS) {
            DEFAULT_OPTIONS[key] = value;
        }
    });
};
export const setOptions = setDefaultOptions;
export { SnapshotService } from './snapshot.js';
export { SoftAssertService } from './softAssert.js';
export { SoftAssertionService } from './softAssertService.js';
export * as utils from './utils.js';
