import { copyFileSync, existsSync, mkdirSync, writeFileSync } from "fs";
import { join } from "path";
import properties from "properties";
const writeJson = (path, data) => {
    writeFileSync(path, JSON.stringify(data), "utf8");
};
export class FileSystemAllureWriter {
    config;
    constructor(config) {
        this.config = config;
        if (!existsSync(this.config.resultsDir)) {
            mkdirSync(this.config.resultsDir, {
                recursive: true,
            });
        }
    }
    writeAttachment(name, content, encoding = "utf-8") {
        const path = this.buildPath(name);
        writeFileSync(path, content, encoding);
    }
    writeAttachmentFromPath(from, distFileName) {
        const to = this.buildPath(distFileName);
        copyFileSync(from, to);
    }
    writeEnvironmentInfo(info) {
        const text = properties.stringify(info, { unicode: true }).toString();
        const path = this.buildPath("environment.properties");
        writeFileSync(path, text);
    }
    writeCategoriesDefinitions(categories) {
        const path = this.buildPath("categories.json");
        writeJson(path, categories);
    }
    writeGroup(result) {
        const path = this.buildPath(`${result.uuid}-container.json`);
        writeJson(path, result);
    }
    writeResult(result) {
        const path = this.buildPath(`${result.uuid}-result.json`);
        writeJson(path, result);
    }
    buildPath(name) {
        return join(this.config.resultsDir, name);
    }
}
//# sourceMappingURL=FileSystemAllureWriter.js.map