import fs from "fs";
export const parseTestPlan = () => {
    const testPlanPath = process.env.ALLURE_TESTPLAN_PATH;
    if (!testPlanPath) {
        return undefined;
    }
    try {
        const file = fs.readFileSync(testPlanPath, "utf8");
        const testPlan = JSON.parse(file);
        if ((testPlan.tests || []).length === 0) {
            return undefined;
        }
        return testPlan;
    }
    catch (e) {
        return undefined;
    }
};
//# sourceMappingURL=testplan.js.map