import { createHash, randomUUID } from "crypto";
import { AllureBaseRuntime } from "../framework/AllureRuntime.js";
export class AllureNodeRuntime extends AllureBaseRuntime {
    constructor(config) {
        super(config, {
            uuid: () => {
                return randomUUID();
            },
            md5: (data) => {
                return createHash("md5").update(data).digest("hex");
            },
        });
    }
    writeAttachmentFromPath(fromPath, options) {
        const fileName = this.buildAttachmentFileName(options);
        this.writer.writeAttachmentFromPath(fromPath, fileName);
        return fileName;
    }
}
//# sourceMappingURL=runtime.js.map