import { typeToExtension } from "../utils";
import { AllureGroup } from "./AllureGroup";
export class AllureBaseRuntime {
    config;
    writer;
    crypto;
    constructor(config, crypto) {
        this.config = config;
        this.writer = config.writer;
        this.crypto = crypto;
    }
    startGroup(name) {
        const allureContainer = new AllureGroup(this);
        allureContainer.name = name || "Unnamed";
        return allureContainer;
    }
    buildAttachmentFileName(options) {
        if (typeof options === "string") {
            options = { contentType: options };
        }
        const extension = typeToExtension(options);
        return `${this.crypto.uuid()}-attachment${extension}`;
    }
    writeResult(result) {
        const modifiedResult = this.config.testMapper !== undefined ? this.config.testMapper(result) : result;
        if (modifiedResult != null) {
            this.writer.writeResult(modifiedResult);
        }
    }
    writeGroup(result) {
        this.writer.writeGroup(result);
    }
    writeAttachment(content, options, encoding) {
        const fileName = this.buildAttachmentFileName(options);
        this.writer.writeAttachment(fileName, content, encoding);
        return fileName;
    }
    writeEnvironmentInfo(info) {
        this.writer.writeEnvironmentInfo(info || process.env);
    }
    writeCategoriesDefinitions(categories) {
        const serializedCategories = categories.map((c) => {
            if (c.messageRegex instanceof RegExp) {
                c.messageRegex = c.messageRegex.source;
            }
            if (c.traceRegex instanceof RegExp) {
                c.traceRegex = c.traceRegex.source;
            }
            return c;
        });
        this.writer.writeCategoriesDefinitions(serializedCategories);
    }
}
//# sourceMappingURL=AllureRuntime.js.map