/// <reference types="node" />
import { AttachmentOptions, Category, ContentType, Crypto, TestResult, TestResultContainer } from "../model";
import { AllureConfig } from "./AllureConfig";
import { AllureGroup } from "./AllureGroup";
import { AllureWriter } from "./AllureWriter";
export interface AllureRuntime {
    writer: AllureWriter;
    crypto: Crypto;
    startGroup(name?: string): AllureGroup;
    buildAttachmentFileName(options: ContentType | string | AttachmentOptions): string;
    writeResult(result: TestResult): void;
    writeGroup(result: TestResultContainer): void;
    writeAttachment(content: Buffer | string, options: ContentType | string | AttachmentOptions, encoding?: BufferEncoding): string;
    writeEnvironmentInfo(info?: Record<string, string>): void;
    writeCategoriesDefinitions(categories: Category[]): void;
}
export declare abstract class AllureBaseRuntime implements AllureRuntime {
    private config;
    writer: AllureWriter;
    crypto: Crypto;
    constructor(config: AllureConfig, crypto: Crypto);
    startGroup(name?: string): AllureGroup;
    buildAttachmentFileName(options: ContentType | string | AttachmentOptions): string;
    writeResult(result: TestResult): void;
    writeGroup(result: TestResultContainer): void;
    writeAttachment(content: Buffer | string, options: ContentType | string | AttachmentOptions, encoding?: BufferEncoding): string;
    writeEnvironmentInfo(info?: Record<string, string>): void;
    writeCategoriesDefinitions(categories: Category[]): void;
}
